/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shared;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.SharedData;
import io.vertx.tp.plugin.shared.SharedClient;
import io.vertx.up.atom.Kv;
import io.vertx.up.exception.web._500SharedDataModeException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SharedClientImpl<K, V>
implements SharedClient<K, V> {
    private static final Annal LOGGER = Annal.get(SharedClientImpl.class);
    private static final ConcurrentMap<String, SharedClient> CLIENTS = new ConcurrentHashMap<String, SharedClient>();
    private final transient Vertx vertx;
    private transient LocalMap<K, V> syncMap;
    private transient AsyncMap<K, V> asyncMap;
    private transient String poolName;

    SharedClientImpl(Vertx vertx, String name) {
        this.vertx = vertx;
        this.poolName = name;
    }

    public static <K, V> SharedClient<K, V> create(Vertx vertx, String name) {
        return (SharedClient)Fn.pool(CLIENTS, (Object)name, () -> new SharedClientImpl(vertx, name));
    }

    private void async(Handler<AsyncResult<AsyncMap<K, V>>> handler) {
        if (Objects.isNull(this.asyncMap)) {
            SharedData sd = this.vertx.sharedData();
            LOGGER.info("( Async ) You are using async mode to create AsyncMap, begin to singleton.", new Object[0]);
            sd.getAsyncMap(this.poolName, res -> {
                if (res.succeeded()) {
                    this.asyncMap = (AsyncMap)res.result();
                    LOGGER.info("( Async ) Your AsyncMap {1} = {0} has been created successfully, you can use it now.", new Object[]{String.valueOf(this.asyncMap.hashCode()), this.poolName});
                    handler.handle((Object)Future.succeededFuture((Object)((AsyncMap)res.result())));
                } else {
                    _500SharedDataModeException error = new _500SharedDataModeException(this.getClass(), res.cause());
                    handler.handle((Object)Future.failedFuture((Throwable)((Object)error)));
                }
            });
        } else {
            handler.handle((Object)Future.succeededFuture(this.asyncMap));
        }
    }

    private LocalMap<K, V> sync() {
        if (Objects.isNull(this.syncMap)) {
            SharedData sd = this.vertx.sharedData();
            this.syncMap = sd.getLocalMap(this.poolName);
            LOGGER.info("( Sync ) You are using sync mode to create LocalMap: {1} = {0}", new Object[]{String.valueOf(this.syncMap.hashCode()), this.poolName});
        }
        return this.syncMap;
    }

    @Override
    public SharedClient<K, V> switchClient(String name) {
        return SharedClientImpl.create(this.vertx, name);
    }

    @Override
    public Kv<K, V> put(K key, V value) {
        Object reference = this.sync().get(key);
        Fn.safeSemi((null == reference ? 1 : 0) != 0, (Annal)LOGGER, () -> this.sync().put(key, value), () -> this.sync().replace(key, value));
        return Kv.create(key, value);
    }

    @Override
    public Kv<K, V> put(K key, V value, int seconds) {
        Kv<K, V> result = this.put(key, value);
        LOGGER.info("( Timer ) You called timer put method, the key \"{0}\" will be expired in {1} seconds", new Object[]{String.valueOf(key), String.valueOf(seconds)});
        this.vertx.setTimer((long)(seconds * 1000), id -> {
            V existing = this.get(key);
            if (Objects.nonNull(existing)) {
                LOGGER.info("( Timer ) The key \"{0}\" refered data has been removed.", new Object[]{String.valueOf(key)});
                this.remove(key);
            } else {
                LOGGER.info("( Timer ) The key \"{0}\" does not exist, it has been removed before.", new Object[]{String.valueOf(key)});
            }
        });
        return result;
    }

    @Override
    public SharedClient<K, V> put(K key, V value, Handler<AsyncResult<Kv<K, V>>> handler) {
        this.async(map -> ((AsyncMap)map.result()).get(key, res -> {
            if (res.succeeded()) {
                Object reference = res.result();
                Fn.safeSemi((null == reference ? 1 : 0) != 0, (Annal)LOGGER, () -> ((AsyncMap)map.result()).put(key, value, added -> {
                    if (added.succeeded()) {
                        handler.handle((Object)Future.succeededFuture((Object)Kv.create((Object)key, (Object)value)));
                    } else {
                        _500SharedDataModeException error = new _500SharedDataModeException(this.getClass(), added.cause());
                        handler.handle((Object)Future.failedFuture((Throwable)((Object)error)));
                    }
                }), () -> ((AsyncMap)map.result()).replace(key, value, replaced -> {
                    if (replaced.succeeded()) {
                        handler.handle((Object)Future.succeededFuture((Object)Kv.create((Object)key, (Object)value)));
                    } else {
                        _500SharedDataModeException error = new _500SharedDataModeException(this.getClass(), replaced.cause());
                        handler.handle((Object)Future.failedFuture((Throwable)((Object)error)));
                    }
                }));
            } else {
                _500SharedDataModeException error = new _500SharedDataModeException(this.getClass(), res.cause());
                handler.handle((Object)Future.failedFuture((Throwable)((Object)error)));
            }
        }));
        return this;
    }

    @Override
    public SharedClient<K, V> put(K key, V value, int seconds, Handler<AsyncResult<Kv<K, V>>> handler) {
        SharedClient<K, V> reference = this.put(key, value, handler);
        LOGGER.info("( Timer ) You called timer put method, the key \"{0}\" will be expired in {1} seconds", new Object[]{String.valueOf(key), String.valueOf(seconds)});
        this.vertx.setTimer((long)(seconds * 1000), id -> this.remove(key, res -> LOGGER.info("( Timer ) The key \"{0}\" refered data has been removed.", new Object[]{key})));
        return reference;
    }

    @Override
    public Kv<K, V> remove(K key) {
        Object removed = this.sync().remove(key);
        return Kv.create(key, (Object)removed);
    }

    @Override
    public V get(K key) {
        return (V)this.sync().get(key);
    }

    @Override
    public boolean clear() {
        this.sync().clear();
        return true;
    }

    @Override
    public V get(K key, boolean once) {
        V value = this.get(key);
        if (once) {
            this.remove(key);
        }
        return value;
    }

    @Override
    public SharedClient<K, V> remove(K key, Handler<AsyncResult<Kv<K, V>>> handler) {
        this.async(map -> ((AsyncMap)map.result()).remove(key, res -> {
            if (res.succeeded()) {
                Object reference = res.result();
                handler.handle((Object)Future.succeededFuture((Object)Kv.create((Object)key, (Object)reference)));
            } else {
                _500SharedDataModeException error = new _500SharedDataModeException(this.getClass(), res.cause());
                handler.handle((Object)Future.failedFuture((Throwable)((Object)error)));
            }
        }));
        return this;
    }

    @Override
    public SharedClient<K, V> get(K key, Handler<AsyncResult<V>> handler) {
        this.async(map -> ((AsyncMap)map.result()).get(key, handler));
        return this;
    }

    @Override
    public SharedClient<K, V> get(K key, boolean once, Handler<AsyncResult<V>> handler) {
        SharedClient<K, V> reference = this.get(key, handler);
        if (once) {
            this.async(map -> ((AsyncMap)map.result()).remove(key, handler));
        }
        return reference;
    }

    @Override
    public SharedClient<K, V> clear(Handler<AsyncResult<Boolean>> handler) {
        this.async(map -> ((AsyncMap)map.result()).clear(result -> handler.handle((Object)Future.succeededFuture((Object)Boolean.TRUE))));
        return this;
    }

    @Override
    public SharedClient<K, V> size(Handler<AsyncResult<Integer>> handler) {
        this.async(map -> ((AsyncMap)map.result()).size(handler));
        return this;
    }

    @Override
    public SharedClient<K, V> keys(Handler<AsyncResult<Set<K>>> handler) {
        this.async(map -> ((AsyncMap)map.result()).keys(handler));
        return this;
    }

    @Override
    public int size() {
        return this.sync().size();
    }

    @Override
    public Set<K> keys() {
        return this.sync().keySet();
    }
}

