/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.atom.container;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.up.log.Annal;

public class VUser
implements User {
    private static final Annal LOGGER = Annal.get(VUser.class);
    private final transient JsonObject principal;

    public VUser(JsonObject principal) {
        this.principal = principal;
    }

    public User merge(User user) {
        this.principal.mergeIn(user.principal());
        return this;
    }

    public User isAuthorized(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        LOGGER.info("You have used virtual user, only principal = {0} is working.", new Object[]{this.principal});
        return this;
    }

    public User clearCache() {
        LOGGER.info("You have used virtual user, only principal = {0} is working.", new Object[]{this.principal});
        return null;
    }

    public JsonObject principal() {
        return this.principal;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        LOGGER.info("You have used virtual user, only principal = {0} is working.", new Object[]{this.principal});
    }

    public JsonObject attributes() {
        return null;
    }

    public User isAuthorized(Authorization authorization, Handler<AsyncResult<Boolean>> handler) {
        return null;
    }
}

