/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.ActOut;
import io.vertx.up.commune.Record;
import io.vertx.up.util.Ut;
import java.util.Objects;

class Act {
    Act() {
    }

    static ActOut empty() {
        return new ActOut(new JsonObject(), HttpStatusCode.NO_CONTENT);
    }

    static ActOut response(Boolean result) {
        return new ActOut(result);
    }

    static ActOut response(Buffer buffer) {
        return new ActOut(buffer);
    }

    static ActOut response(Throwable ex) {
        return new ActOut(ex);
    }

    static ActOut response(JsonObject data) {
        if (Objects.isNull(data)) {
            return Act.empty();
        }
        return new ActOut(data);
    }

    static ActOut response(JsonArray data) {
        if (Objects.isNull(data)) {
            return Act.empty();
        }
        return new ActOut(data);
    }

    static ActOut response(Record[] records) {
        JsonArray result = Ut.toJArray((Record[])records);
        return Act.response(result);
    }

    static ActOut response(Record record) {
        if (Objects.isNull(record)) {
            return Act.empty();
        }
        return new ActOut(record.toJson());
    }
}

