/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.ActMapping;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.exchange.BiTree;
import io.vertx.up.eon.Constants;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;

class ActJArray
extends ActMapping
implements Serializable {
    private final transient JsonArray data = new JsonArray();
    private final transient JsonObject header;

    ActJArray(Envelop envelop) {
        this.header = envelop.headersX();
        this.partData(envelop);
    }

    private void partData(Envelop envelop) {
        JsonObject rawJson = (JsonObject)envelop.data();
        if (!Ut.isNil((JsonObject)rawJson)) {
            long counter = rawJson.fieldNames().stream().filter(Constants.INDEXES::containsValue).count();
            if (0L < counter) {
                JsonArray found = rawJson.fieldNames().stream().filter(Objects::nonNull).map(arg_0 -> ((JsonObject)rawJson).getValue(arg_0)).filter(value -> value instanceof JsonArray).map(item -> (JsonArray)item).findFirst().orElse(null);
                JsonArray body = null == found ? new JsonArray() : found.copy();
                this.data.addAll(body);
            } else {
                JsonArray inputData = new JsonArray();
                if (rawJson.containsKey("$$__BODY__$$") && Objects.nonNull(inputData = rawJson.getJsonArray("$$__BODY__$$"))) {
                    inputData = inputData.copy();
                }
                inputData.stream().filter(item -> item instanceof JsonObject).map(item -> (JsonObject)item).forEach(item -> item.mergeIn(this.header.copy(), true));
                this.data.addAll(inputData);
            }
        }
    }

    Record[] getRecords(Record definition, BiTree mapping) {
        int size = this.data.size();
        Record[] records = new Record[size];
        for (int idx = 0; idx < size; ++idx) {
            Object input = this.data.getValue(idx);
            records[idx] = this.getRecord(input, definition, mapping);
        }
        return records;
    }

    JsonArray getJson(BiTree mapping) {
        if (this.isBefore(mapping)) {
            JsonArray normalized = new JsonArray();
            Ut.itJArray((JsonArray)this.data).map(item -> this.mapper().in(item, mapping.child())).forEach(arg_0 -> ((JsonArray)normalized).add(arg_0));
            return normalized;
        }
        return this.data;
    }
}

