/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune.envelop;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.envelop.Rib;
import io.vertx.up.eon.Constants;
import io.vertx.up.util.Ut;
import java.util.Objects;

class RibData {
    RibData() {
    }

    static <T> T get(JsonObject data) {
        if (Objects.isNull(data) || !data.containsKey("data")) {
            return null;
        }
        Object value = data.getValue("data");
        if (Objects.isNull(value)) {
            return null;
        }
        return (T)value;
    }

    static <T> T get(JsonObject data, Class<?> clazz) {
        T reference = null;
        if (data.containsKey("data")) {
            Object value = data.getValue("data");
            reference = Rib.deserialize(value, clazz);
        }
        return reference;
    }

    static JsonObject getBody(JsonObject data) {
        return (JsonObject)RibData.get(data, JsonObject.class);
    }

    static <T> T get(JsonObject data, Class<?> clazz, Integer index) {
        Object reference = null;
        if (data.containsKey("data")) {
            Object rawData = data.getValue("data");
            if (rawData instanceof JsonObject) {
                JsonObject raw = (JsonObject)rawData;
                if (Ut.isNil((JsonObject)raw)) {
                    return null;
                }
                String key = (String)Constants.INDEXES.get(index);
                if (raw.containsKey(key)) {
                    reference = Rib.deserialize(raw.getValue(key), clazz);
                } else if (JsonObject.class == clazz) {
                    reference = raw;
                }
            } else {
                reference = rawData;
            }
        }
        return (T)reference;
    }

    static <T> void set(JsonObject data, String field, T value, Integer argIndex) {
        Object reference = RibData.getData(data, argIndex);
        if (reference instanceof JsonObject) {
            JsonObject ref = (JsonObject)reference;
            ref.put(field, value);
        } else if (reference instanceof JsonArray) {
            JsonArray ref = (JsonArray)reference;
            Ut.itJArray((JsonArray)ref).forEach(refEach -> refEach.put(field, value));
        }
    }

    private static Object getData(JsonObject data, Integer argIndex) {
        Object found;
        JsonObject itRef = data;
        if (data.containsKey("data")) {
            itRef = data.getJsonObject("data");
        }
        if (null == argIndex) {
            found = RibData.findSmart(itRef);
            if (Objects.isNull(found)) {
                found = itRef;
            }
        } else {
            return RibData.findByIndex(itRef, argIndex);
        }
        return found;
    }

    private static Object findByIndex(JsonObject itPart, Integer argIndex) {
        return itPart.getValue((String)Constants.INDEXES.get(argIndex));
    }

    private static Object findSmart(JsonObject itPart) {
        Object body = itPart.fieldNames().stream().filter(Objects::nonNull).map(arg_0 -> ((JsonObject)itPart).getValue(arg_0)).filter(value -> value instanceof JsonObject || value instanceof JsonArray).findFirst().orElse(null);
        if (Objects.nonNull(body)) {
            if (body instanceof JsonObject && Ut.isNil((JsonObject)body)) {
                return null;
            }
            if (body instanceof JsonArray && Ut.isNil((JsonArray)body)) {
                return null;
            }
        } else {
            return null;
        }
        return body;
    }
}

