/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.runtime;

import com.google.inject.Injector;
import io.vertx.core.http.HttpMethod;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.atom.worker.Receipt;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroPack;
import io.vertx.up.runtime.ZeroUri;
import io.vertx.up.uca.web.origin.AgentInquirer;
import io.vertx.up.uca.web.origin.EndPointInquirer;
import io.vertx.up.uca.web.origin.EventInquirer;
import io.vertx.up.uca.web.origin.FilterInquirer;
import io.vertx.up.uca.web.origin.GuiceInquirer;
import io.vertx.up.uca.web.origin.Inquirer;
import io.vertx.up.uca.web.origin.IpcInquirer;
import io.vertx.up.uca.web.origin.JobInquirer;
import io.vertx.up.uca.web.origin.PluginInquirer;
import io.vertx.up.uca.web.origin.QueueInquirer;
import io.vertx.up.uca.web.origin.ReceiptInquirer;
import io.vertx.up.uca.web.origin.WallInquirer;
import io.vertx.up.uca.web.origin.WorkerInquirer;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ZeroAnno {
    private static final Annal LOGGER = Annal.get(ZeroAnno.class);
    private static final Set<Class<?>> ENDPOINTS = new HashSet();
    private static final Set<Receipt> RECEIPTS = new HashSet<Receipt>();
    private static final Set<Event> EVENTS = new HashSet<Event>();
    private static final ConcurrentMap<String, Set<Event>> FILTERS = new ConcurrentHashMap<String, Set<Event>>();
    private static final ConcurrentMap<ServerType, List<Class<?>>> AGENTS = new ConcurrentHashMap();
    private static final Set<Class<?>> WORKERS = new HashSet();
    private static final Set<Aegis> WALLS = new TreeSet<Aegis>();
    private static final ConcurrentMap<String, Method> IPCS = new ConcurrentHashMap<String, Method>();
    private static final Set<Class<?>> TPS = new HashSet();
    private static final Set<Mission> JOBS = new HashSet<Mission>();
    private static Injector DI;

    public static void booting() {
        Set clazzes = ZeroPack.getClasses();
        Inquirer guice = (Inquirer)Ut.singleton(GuiceInquirer.class, (Object[])new Object[0]);
        DI = (Injector)guice.scan(clazzes);
        Inquirer inquirer = (Inquirer)Ut.singleton(EndPointInquirer.class, (Object[])new Object[0]);
        ENDPOINTS.addAll((Collection)inquirer.scan(clazzes));
        Fn.safeSemi((!ENDPOINTS.isEmpty() ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            Inquirer event = (Inquirer)Ut.singleton(EventInquirer.class, (Object[])new Object[0]);
            EVENTS.addAll((Collection)event.scan(ENDPOINTS));
        });
        EVENTS.stream().filter(Objects::nonNull).filter(item -> 0 < item.getPath().indexOf(":")).forEach(ZeroUri::resolve);
        ZeroUri.report();
        Inquirer walls = (Inquirer)Ut.singleton(WallInquirer.class, (Object[])new Object[0]);
        WALLS.addAll((Collection)walls.scan(clazzes));
        Inquirer filters = (Inquirer)Ut.singleton(FilterInquirer.class, (Object[])new Object[0]);
        FILTERS.putAll((Map)filters.scan(clazzes));
        inquirer = (Inquirer)Ut.singleton(QueueInquirer.class, (Object[])new Object[0]);
        Set queues = (Set)inquirer.scan(clazzes);
        Fn.safeSemi((!queues.isEmpty() ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            Inquirer receipt = (Inquirer)Ut.singleton(ReceiptInquirer.class, (Object[])new Object[0]);
            RECEIPTS.addAll((Collection)receipt.scan(queues));
        });
        Inquirer ipc = (Inquirer)Ut.singleton(IpcInquirer.class, (Object[])new Object[0]);
        IPCS.putAll((Map)ipc.scan(clazzes));
        Inquirer agent = (Inquirer)Ut.singleton(AgentInquirer.class, (Object[])new Object[0]);
        AGENTS.putAll((Map)agent.scan(clazzes));
        Inquirer tps = (Inquirer)Ut.singleton(PluginInquirer.class, (Object[])new Object[0]);
        TPS.addAll((Collection)tps.scan(clazzes));
        Inquirer worker = (Inquirer)Ut.singleton(WorkerInquirer.class, (Object[])new Object[0]);
        WORKERS.addAll((Collection)worker.scan(clazzes));
        Inquirer jobs = (Inquirer)Ut.singleton(JobInquirer.class, (Object[])new Object[0]);
        JOBS.addAll((Collection)jobs.scan(clazzes));
    }

    public static Injector getDi() {
        return DI;
    }

    public static ConcurrentMap<ServerType, List<Class<?>>> getAgents() {
        return AGENTS;
    }

    public static Set<Class<?>> getTps() {
        return TPS;
    }

    public static Set<Mission> getJobs() {
        return JOBS;
    }

    public static Set<Class<?>> getWorkers() {
        return WORKERS;
    }

    public static Set<Receipt> getReceipts() {
        return RECEIPTS;
    }

    public static Set<Class<?>> getEndpoints() {
        return ENDPOINTS;
    }

    public static ConcurrentMap<String, Method> getIpcs() {
        return IPCS;
    }

    public static Set<Event> getEvents() {
        return EVENTS;
    }

    public static ConcurrentMap<String, Set<Event>> getFilters() {
        return FILTERS;
    }

    public static Set<Aegis> getWalls() {
        return WALLS;
    }

    public static String recoveryUri(String uri, HttpMethod method) {
        return ZeroUri.recovery(uri, method);
    }
}

