/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.runtime.soul;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.up.fn.Fn;
import io.vertx.up.runtime.soul.UriMeta;
import io.vertx.up.runtime.soul.UriNeuro;
import io.vertx.up.runtime.soul.UriStore;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UriAeon {
    private static final ConcurrentMap<String, UriNeuro> NEURO = new ConcurrentHashMap<String, UriNeuro>();
    private static final UriStore STORE = UriStore.create();

    public static void connect(Router router) {
        String threadId = Thread.currentThread().getName();
        Fn.poolThread(NEURO, () -> UriNeuro.getInstance(threadId).bind(router));
    }

    public static void mountRoute(JsonObject config) {
        NEURO.values().forEach(neuro -> neuro.addRoute(config));
    }

    public static void uriAdd(UriMeta meta) {
        if (Objects.nonNull(meta)) {
            STORE.add(meta);
        }
    }

    public static List<UriMeta> uriSearch(String keyword) {
        return STORE.search(keyword);
    }

    public static List<UriMeta> uriGet() {
        return STORE.getAll();
    }
}

