/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.runtime.soul;

import io.vertx.up.annotations.Address;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.worker.Receipt;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.runtime.soul.UriMeta;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

class UriStore {
    private static final ConcurrentMap<String, UriMeta> URIS = new ConcurrentHashMap<String, UriMeta>();
    private static UriStore INSTANCE;

    private UriStore() {
    }

    static UriStore create() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new UriStore();
        }
        return INSTANCE;
    }

    UriStore add(UriMeta meta) {
        String cacheKey = meta.getCacheKey();
        if (Ut.notNil((String)cacheKey)) {
            URIS.put(cacheKey, meta);
        }
        return this;
    }

    List<UriMeta> getAll() {
        ArrayList<UriMeta> uris = new ArrayList<UriMeta>(URIS.values());
        uris.sort(Comparator.comparing(UriMeta::getUri));
        return uris;
    }

    List<UriMeta> search(String keyword) {
        if (Ut.isNil((String)keyword)) {
            return new ArrayList<UriMeta>();
        }
        List<UriMeta> sortedList = this.getAll();
        return sortedList.stream().filter(item -> {
            if (item.getUri().contains(keyword)) {
                return true;
            }
            if (Ut.isNil((String)item.getName())) {
                return false;
            }
            return item.getName().contains(keyword);
        }).collect(Collectors.toList());
    }

    static {
        Set<Receipt> receipts = ZeroAnno.getReceipts();
        ConcurrentMap receiptMap = Ut.elementMap(new ArrayList<Receipt>(receipts), Receipt::getAddress);
        Set<Event> events = ZeroAnno.getEvents();
        for (Event event : events) {
            String cacheKey;
            UriMeta uriMeta = new UriMeta();
            uriMeta.setMethod(event.getMethod());
            uriMeta.setUri(event.getPath());
            uriMeta.setDynamic(Boolean.FALSE);
            uriMeta.setComment(event.getPath());
            uriMeta.setName(event.getPath());
            Method method = event.getAction();
            Address annotation = method.getDeclaredAnnotation(Address.class);
            String address = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
            if (Objects.nonNull(address) && receiptMap.containsKey(address)) {
                Receipt receipt = (Receipt)receiptMap.get(address);
                uriMeta.setAddress(address);
                uriMeta.setWorkerMethod(receipt.getMethod());
            }
            if (!Ut.notNil((String)(cacheKey = uriMeta.getCacheKey()))) continue;
            URIS.put(cacheKey, uriMeta);
        }
    }
}

