/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.bridge;

import io.vertx.core.Vertx;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.tp.error.WallItemSizeException;
import io.vertx.tp.error.WallProviderConflictException;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.eon.em.AuthWall;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.Lee;
import io.vertx.up.secure.LeeBuiltIn;
import io.vertx.up.secure.LeeExtension;
import io.vertx.up.secure.bridge.Bolt;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

class BoltWhich
implements Bolt {
    private static final Annal LOGGER = Annal.get(BoltWhich.class);
    private static final AtomicBoolean[] LOG_LEE = new AtomicBoolean[]{new AtomicBoolean(Boolean.TRUE), new AtomicBoolean(Boolean.TRUE), new AtomicBoolean(Boolean.TRUE)};
    private static final ConcurrentMap<String, Lee> POOL_LEE = new ConcurrentHashMap<String, Lee>();
    static ConcurrentMap<String, Bolt> POOL_BOLT = new ConcurrentHashMap<String, Bolt>();

    BoltWhich() {
    }

    @Override
    public AuthenticationHandler authenticate(Vertx vertx, Aegis config) {
        Objects.requireNonNull(config);
        if (config.noAuthentication()) {
            if (LOG_LEE[0].getAndSet(Boolean.FALSE)) {
                LOGGER.warn("[ Auth ] Your `@Wall` class missed @Authenticate method ! {0}", new Object[]{config});
            }
            return null;
        }
        Aegis verified = this.verifyAuthenticate(config);
        Lee lee = this.reference(config);
        if (Objects.isNull(lee)) {
            if (LOG_LEE[1].getAndSet(Boolean.FALSE)) {
                LOGGER.warn("[ Auth ] Your `Lee` in service-loader /META-INF/services/ is missing....", new Object[]{config.getType()});
            }
            return null;
        }
        AuthenticationHandler handler = lee.authenticate(vertx, verified);
        if (Objects.isNull(handler) && LOG_LEE[2].getAndSet(Boolean.FALSE)) {
            LOGGER.warn("[ Auth ] You have configured secure, but the authenticate handler is null! type = {0}", new Object[]{config.getType()});
        }
        return handler;
    }

    @Override
    public AuthorizationHandler authorization(Vertx vertx, Aegis config) {
        Objects.requireNonNull(config);
        if (config.noAuthorization()) {
            return null;
        }
        Lee lee = this.reference(config);
        if (Objects.isNull(lee)) {
            return null;
        }
        return lee.authorization(vertx, config);
    }

    private Aegis verifyAuthenticate(Aegis config) {
        if (AuthWall.EXTENSION != config.getType()) {
            AegisItem item2 = config.item();
            Fn.outUp((boolean)Objects.isNull(item2), WallItemSizeException.class, (Object[])new Object[]{this.getClass(), config.getType(), 1});
        }
        Set provider = config.providers();
        provider.forEach(item -> Fn.outUp((!AuthenticationProvider.class.isAssignableFrom((Class<?>)item) ? 1 : 0) != 0, WallProviderConflictException.class, (Object[])new Object[]{this.getClass(), item}));
        return config;
    }

    private Lee reference(Aegis config) {
        AuthWall wall = config.getType();
        if (AuthWall.EXTENSION == wall) {
            return (Lee)Fn.poolThread(POOL_LEE, () -> (Lee)Ut.service(LeeExtension.class), (String)LeeExtension.class.getName());
        }
        return (Lee)Fn.poolThread(POOL_LEE, () -> (Lee)Ut.service(LeeBuiltIn.class), (String)LeeBuiltIn.class.getName());
    }
}

