/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.config;

import com.fasterxml.jackson.databind.JsonArrayDeserializer;
import com.fasterxml.jackson.databind.JsonArraySerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;

public class CorsConfig
implements Serializable {
    private static final String KEY = "cors";
    private static CorsConfig INSTANCE;
    private transient Boolean credentials = Boolean.FALSE;
    @JsonSerialize(using=JsonArraySerializer.class)
    @JsonDeserialize(using=JsonArrayDeserializer.class)
    private transient JsonArray methods = new JsonArray();
    @JsonSerialize(using=JsonArraySerializer.class)
    @JsonDeserialize(using=JsonArrayDeserializer.class)
    private transient JsonArray headers = new JsonArray();
    private transient String origin;

    public static CorsConfig get() {
        return INSTANCE;
    }

    public Boolean getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Boolean credentials) {
        this.credentials = credentials;
    }

    public JsonArray getMethods() {
        if (this.methods.isEmpty()) {
            return new JsonArray().add((Object)HttpMethod.GET.name()).add((Object)HttpMethod.POST.name()).add((Object)HttpMethod.PUT.name()).add((Object)HttpMethod.DELETE.name()).add((Object)HttpMethod.OPTIONS.name());
        }
        return this.methods;
    }

    public void setMethods(JsonArray methods) {
        this.methods = methods;
    }

    public JsonArray getHeaders() {
        if (this.headers.isEmpty()) {
            return new JsonArray().add((Object)HttpHeaders.AUTHORIZATION.toString()).add((Object)HttpHeaders.ACCEPT.toString()).add((Object)HttpHeaders.CONTENT_DISPOSITION.toString()).add((Object)HttpHeaders.CONTENT_ENCODING.toString()).add((Object)HttpHeaders.CONTENT_LENGTH.toString()).add((Object)HttpHeaders.CONTENT_TYPE.toString()).add((Object)"X-App-Id").add((Object)"X-App-Key").add((Object)"X-Sigma");
        }
        return this.headers;
    }

    public void setHeaders(JsonArray headers) {
        this.headers = headers;
    }

    public String getOrigin() {
        return Objects.isNull(this.origin) ? "*" : this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String toString() {
        return "CorsConfig{credentials=" + this.credentials + ", methods=" + this.methods + ", headers=" + this.headers + ", origin='" + this.origin + "'}";
    }

    static {
        JsonObject cors;
        Node visitor = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
        JsonObject config = (JsonObject)visitor.read();
        if (config.containsKey(KEY) && Ut.notNil((JsonObject)(cors = config.getJsonObject(KEY)))) {
            INSTANCE = (CorsConfig)Ut.deserialize((JsonObject)cors, CorsConfig.class);
        }
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new CorsConfig();
        }
    }
}

