/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.cache;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.up.atom.Kv;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxPool;
import io.vertx.up.util.Ut;
import java.util.Objects;

public class AbstractRapid<K, T>
implements Rapid<K, T> {
    protected final transient UxPool pool;
    protected final transient int expired;

    protected AbstractRapid(String poolName, int expired) {
        this.pool = Ux.Pool.on(poolName);
        this.expired = expired;
    }

    protected AbstractRapid(User user) {
        Objects.requireNonNull(user);
        this.expired = -1;
        JsonObject credit = Ut.valueJObject((JsonObject)user.principal());
        String poolName = credit.getString("habitus");
        this.pool = Ux.Pool.on(poolName);
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    @Override
    public Future<T> write(K key, T value) {
        if (0 < this.expired) {
            return this.pool.put(key, value, this.expired).compose(Kv::value);
        }
        return this.pool.put(key, value).compose(Kv::value);
    }

    @Override
    public Future<T> clear(K key) {
        return this.pool.remove(key).compose(Kv::value);
    }

    @Override
    public Future<T> read(K key) {
        return this.pool.get(key);
    }
}

