/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.cache;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.auth.User;
import io.vertx.up.exception.web._501NotSupportException;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.cache.P;
import io.vertx.up.uca.cache.RapidDict;
import io.vertx.up.uca.cache.RapidT;
import io.vertx.up.uca.cache.RapidUser;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Rapid<K, V> {
    public static <TK, TV> Rapid<TK, TV> t(String key) {
        return Rapid.t(key, -1);
    }

    public static <TK, TV> Rapid<TK, TV> t(String key, int ttl) {
        return (Rapid)Fn.poolThread(P.CACHED_THREAD, () -> new RapidT(key, ttl), (String)(RapidT.class.getName() + key + ttl));
    }

    public static Rapid<Set<String>, ConcurrentMap<String, JsonArray>> map(String key) {
        return Rapid.map(key, -1);
    }

    public static Rapid<Set<String>, ConcurrentMap<String, JsonArray>> map(String key, int ttl) {
        return (Rapid)Fn.poolThread(P.CACHED_THREAD, () -> new RapidDict(key, ttl), (String)(RapidDict.class.getName() + key + ttl));
    }

    public static <T> Rapid<String, T> user(User user, String rootKey) {
        return (Rapid)Fn.poolThread(P.CACHED_THREAD, () -> new RapidUser(user, rootKey), (String)(RapidUser.class.getName() + String.valueOf(user.hashCode()) + rootKey));
    }

    public static <T> Rapid<String, T> user(User user) {
        return Rapid.user(user, null);
    }

    default public Future<V> cached(K key, Supplier<Future<V>> executor) {
        throw new _501NotSupportException(this.getClass());
    }

    default public Future<V> cached(K key, Function<K, Future<V>> executor) {
        throw new _501NotSupportException(this.getClass());
    }

    public Future<V> write(K var1, V var2);

    public Future<V> clear(K var1);

    public Future<V> read(K var1);
}

