/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.cache;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.up.atom.Kv;
import io.vertx.up.uca.cache.AbstractRapid;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class RapidDict
extends AbstractRapid<Set<String>, ConcurrentMap<String, JsonArray>> {
    RapidDict(String cacheKey, int expired) {
        super(cacheKey, expired);
    }

    @Override
    public Future<ConcurrentMap<String, JsonArray>> cached(Set<String> keys, Function<Set<String>, Future<ConcurrentMap<String, JsonArray>>> executor) {
        Objects.requireNonNull(keys);
        return this.pool.get(keys).compose(dataMap -> {
            Set keySet = Ut.diff((Set)keys, dataMap.keySet());
            ConcurrentHashMap cached = new ConcurrentHashMap(dataMap);
            if (keySet.isEmpty()) {
                return Ux.future(cached);
            }
            return ((Future)executor.apply(keySet)).compose(queried -> {
                ConcurrentHashMap futureMap = new ConcurrentHashMap();
                queried.forEach((key, data) -> futureMap.put(key, this.pool.put(key, data, this.expired).compose(Kv::value)));
                return Ux.thenCombine(futureMap);
            }).compose(newMap -> {
                cached.putAll(newMap);
                return Ux.future(cached);
            });
        });
    }
}

