/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.cache;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.up.uca.cache.AbstractRapid;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import java.util.function.Supplier;

public class RapidUser<T>
extends AbstractRapid<String, T> {
    private final transient String rootKey;

    RapidUser(User user, String rootKey) {
        super(user);
        this.rootKey = rootKey;
    }

    @Override
    public Future<T> cached(String key, Supplier<Future<T>> executor) {
        Objects.requireNonNull(key);
        return this.pool.get(this.rootKey).compose(cached -> {
            if (Objects.isNull(cached)) {
                cached = new JsonObject();
            }
            if (cached.containsKey(key)) {
                this.logger().info("[ Cache ] \u001b[0;37mK = `{2}`, R = `{1}`, P = `{0}`\u001b[m", new Object[]{this.pool.name(), this.rootKey, key});
                return Ux.future(cached.getValue(key));
            }
            JsonObject stored = cached;
            return ((Future)executor.get()).compose(item -> {
                stored.put(key, item);
                return this.pool.put(this.rootKey, stored).compose(nil -> Ux.future(item));
            });
        });
    }
}

