/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.cosmic;

import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.commune.config.IntegrationRequest;
import io.vertx.up.exception.heart.JexlExpressionException;
import io.vertx.up.exception.web._500RequestConfigException;
import io.vertx.up.exception.web._501HttpClientNullException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.cosmic.Rotator;
import io.vertx.up.util.Ut;
import java.io.IOException;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public abstract class AbstractRotator
implements Rotator {
    private final transient Integration integration;
    private transient CloseableHttpClient client;

    public AbstractRotator(Integration integration) {
        this.integration = integration;
    }

    @Override
    public Rotator bind(CloseableHttpClient client) {
        this.client = client;
        return this;
    }

    protected RequestConfig configRequest() {
        Integer connectTimeout = (Integer)this.integration.getOption("timeout.connect", (Object)5000);
        Integer requestTimeout = (Integer)this.integration.getOption("timeout.request", (Object)5000);
        Integer socketTimeout = (Integer)this.integration.getOption("timeout.socket", (Object)5000);
        return RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(requestTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).build();
    }

    protected String configPath(IntegrationRequest request, JsonObject params) {
        String exprPath = request.getPath();
        if (request.isExpr()) {
            try {
                return request.getPath(params);
            }
            catch (JexlExpressionException ex) {
                ex.printStackTrace();
                throw new _500RequestConfigException(this.getClass(), request, params);
            }
        }
        if (Ut.isNil((String)exprPath)) {
            throw new _500RequestConfigException(this.getClass(), request, params);
        }
        return exprPath;
    }

    protected void configHeader(HttpRequestBase request, JsonObject headers) {
        if (!headers.containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/json");
        }
        if (Ut.notNil((JsonObject)headers)) {
            headers.stream().filter(item -> Objects.nonNull(item.getValue())).forEach(item -> request.addHeader((String)item.getKey(), item.getValue().toString()));
        }
    }

    protected StringEntity dataJson(JsonObject data) {
        JsonObject normalized = Ut.valueJObject((JsonObject)data);
        StringEntity body = new StringEntity(normalized.encode(), "UTF-8");
        body.setContentEncoding("UTF-8");
        body.setContentType("application/json;charset=UTF-8");
        return body;
    }

    protected String dataString(HttpResponse response) throws IOException {
        if (Objects.isNull(response)) {
            this.logger().info("Empty Http Response", new Object[0]);
            return "";
        }
        int statusLine = response.getStatusLine().getStatusCode();
        if (200 == statusLine) {
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            this.logger().info("Success response: {0}", new Object[]{result});
            return result;
        }
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        this.logger().info("Failure response: {0}, code: {1}", new Object[]{result, statusLine});
        return result;
    }

    protected CloseableHttpClient client() {
        if (Objects.isNull(this.client)) {
            throw new _501HttpClientNullException(this.getClass());
        }
        return this.client;
    }

    protected String sendEntity(HttpEntityEnclosingRequestBase request, HttpEntity body, JsonObject headers) {
        RequestConfig config = this.configRequest();
        request.setConfig(config);
        request.setEntity(body);
        this.configHeader((HttpRequestBase)request, headers);
        return (String)Fn.getJvm(() -> {
            CloseableHttpResponse httpResponse = this.client().execute((HttpUriRequest)request);
            return this.dataString((HttpResponse)httpResponse);
        }, (Object[])new Object[0]);
    }

    protected String sendUrl(HttpRequestBase request, JsonObject headers) {
        RequestConfig config = this.configRequest();
        request.setConfig(config);
        this.configHeader(request, headers);
        return (String)Fn.getJvm(() -> {
            CloseableHttpResponse httpResponse = this.client().execute((HttpUriRequest)request);
            return this.dataString((HttpResponse)httpResponse);
        }, (Object[])new Object[0]);
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }
}

