/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.cosmic;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.cosmic.LegacyEmitter;
import io.vertx.up.uca.cosmic.Pool;
import io.vertx.up.uca.cosmic.StandardEmitter;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

public interface Emitter {
    public static Emitter create(Integration integration) {
        if (Objects.isNull(integration)) {
            return null;
        }
        String publicFile = integration.getPublicKeyFile();
        if (Ut.isNil((String)publicFile)) {
            return (Emitter)Fn.pool(Pool.POOL_EMITTER, (Object)integration.hashCode(), () -> new StandardEmitter(integration));
        }
        return (Emitter)Fn.pool(Pool.POOL_EMITTER, (Object)integration.hashCode(), () -> new LegacyEmitter(integration));
    }

    public String request(String var1, JsonObject var2, MultiMap var3);

    default public String request(String apiKey, JsonObject params) {
        return this.request(apiKey, params, MultiMap.caseInsensitiveMultiMap());
    }

    default public Future<String> requestAsync(String apiKey, JsonObject params, MultiMap headers) {
        return Ux.future(this.request(apiKey, params, headers));
    }

    default public Future<String> requestAsync(String apiKey, JsonObject params) {
        return Ux.future(this.request(apiKey, params));
    }

    public JsonArray requestA(String var1, JsonObject var2, MultiMap var3);

    default public Future<JsonArray> requestAsyncA(String apiKey, JsonObject params, MultiMap headers) {
        return Ux.future(this.requestA(apiKey, params, headers));
    }

    default public JsonArray requestA(String apiKey, JsonObject params) {
        return this.requestA(apiKey, params, MultiMap.caseInsensitiveMultiMap());
    }

    default public Future<JsonArray> requestAsyncA(String apiKey, JsonObject params) {
        return Ux.future(this.requestA(apiKey, params));
    }

    public JsonObject requestJ(String var1, JsonObject var2, MultiMap var3);

    default public Future<JsonObject> requestAsyncJ(String apiKey, JsonObject params, MultiMap headers) {
        return Ux.future(this.requestJ(apiKey, params, headers));
    }

    default public JsonObject requestJ(String apiKey, JsonObject params) {
        return this.requestJ(apiKey, params, MultiMap.caseInsensitiveMultiMap());
    }

    default public Future<JsonObject> requestAsyncJ(String apiKey, JsonObject params) {
        return Ux.future(this.requestJ(apiKey, params));
    }
}

