/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.di;

import com.google.inject.AbstractModule;
import io.vertx.up.uca.di.DiGuice;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class DiGuiceConstructor<T extends I, I>
implements DiGuice<T, I> {
    private final transient Set<Class<?>> pointers = new HashSet();

    @Override
    public boolean success(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        return Arrays.stream(constructors).filter(constructor -> !Modifier.isPublic(constructor.getModifiers())).filter(constructor -> 0 < constructor.getParameterCount()).filter(constructor -> constructor.isAnnotationPresent(Inject.class)).anyMatch(constructor -> {
            Class<?>[] parameters = constructor.getParameterTypes();
            this.pointers.addAll(Arrays.asList(parameters));
            return true;
        });
    }

    @Override
    public AbstractModule module(ConcurrentMap<Class<I>, Set<Class<T>>> tree, Set<Class<T>> flat) {
        return new AbstractModule(){

            protected void configure() {
            }
        };
    }
}

