/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.di;

import com.google.inject.AbstractModule;
import io.vertx.up.uca.di.DiGuice;
import io.vertx.up.uca.di.DiGuiceModule;
import io.vertx.up.util.Ut;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class DiGuiceField<T extends I, I>
implements DiGuice<T, I> {
    private final transient Set<Class<?>> pointers = new HashSet();

    @Override
    public boolean success(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        HashSet extract = new HashSet();
        Arrays.stream(fields).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> field.isAnnotationPresent(Inject.class)).forEach(field -> extract.add(field.getType()));
        if (!extract.isEmpty()) {
            this.pointers.addAll(extract);
        }
        return !extract.isEmpty();
    }

    @Override
    public AbstractModule module(final ConcurrentMap<Class<I>, Set<Class<T>>> tree, final Set<Class<T>> flat) {
        final Set<Class<?>> classes = this.pointers;
        return new DiGuiceModule(){

            protected void configure() {
                if (!classes.isEmpty()) {
                    this.logger().info("[ DI ] Field Scanner booting...", new Object[0]);
                    HashSet ignoreSet = new HashSet();
                    classes.forEach(clazz -> {
                        Set implCls;
                        Set<String> ignored;
                        if (flat.contains(clazz)) {
                            String bindCls = this.bindConstructor(clazz);
                            if (Objects.nonNull(bindCls)) {
                                ignoreSet.add(bindCls);
                            }
                        } else if (clazz.isInterface() && Objects.nonNull(ignored = this.bindInterface(clazz, implCls = (Set)tree.get(clazz)))) {
                            ignoreSet.addAll(ignored);
                        }
                    });
                    if (ignoreSet.isEmpty()) {
                        this.logger().info("[ DI ] Field Scanned Successfully !!!", new Object[0]);
                    } else {
                        this.logger().info("[ DI ] Field Scanned Successfully with ignored: {0} !!!", new Object[]{Ut.fromJoin(ignoreSet)});
                    }
                }
            }
        };
    }
}

