/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.di;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;

public abstract class DiGuiceModule
extends AbstractModule {
    protected <T> String bindConstructor(Class<T> clazz) {
        if (Ut.withNoArgConstructor(clazz)) {
            Constructor constructor = Ut.constructor(clazz, (Object[])new Object[0]);
            this.bind(clazz).toConstructor(constructor).asEagerSingleton();
            this.logger().info("[ DI ] Constructor Bind: `{0}`", new Object[]{clazz});
            return null;
        }
        return clazz.getName();
    }

    protected <T extends I, I> Set<String> bindInterface(Class<I> interfaceCls, Set<Class<T>> implSet) {
        if (!implSet.isEmpty()) {
            HashSet<String> clazzSet = new HashSet<String>();
            if (1 == implSet.size()) {
                Class<T> clazz = implSet.iterator().next();
                this.bind(interfaceCls).to(clazz).asEagerSingleton();
                this.logger().info("[ DI ] Interface Bind: `{0}`, interfaceCls = `{1}`", new Object[]{clazz, interfaceCls});
            } else {
                implSet.forEach(implCls -> {
                    if (implCls.isAnnotationPresent(Named.class)) {
                        Named annotation = implCls.getAnnotation(Named.class);
                        String name = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
                        this.logger().info("[ DI ] Interface Bind: `{0}`, interfaceCls = `{1}`, name", new Object[]{implCls, interfaceCls, name});
                        this.bind(interfaceCls).annotatedWith((Annotation)Names.named((String)name)).to(implCls).asEagerSingleton();
                    } else {
                        clazzSet.add(implCls.getName());
                    }
                });
            }
            return clazzSet;
        }
        return null;
    }

    protected Annal logger() {
        return Annal.get(((Object)((Object)this)).getClass());
    }
}

