/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.invoker;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.up.commune.Envelop;
import io.vertx.up.uca.invoker.AbstractInvoker;
import io.vertx.up.uca.invoker.InvokerUtil;
import io.vertx.up.unity.Ux;
import java.lang.reflect.Method;

public class DynamicInvoker
extends AbstractInvoker {
    @Override
    public void ensure(Class<?> returnType, Class<?> paramCls) {
        boolean valid = Void.TYPE != returnType && Void.class != returnType;
        InvokerUtil.verify(!valid, returnType, paramCls, this.getClass());
    }

    @Override
    public void invoke(Object proxy, Method method, Message<Envelop> message) {
        Envelop envelop = (Envelop)message.body();
        this.getLogger().info("( Invoker ) Invoker = {0}, ReturnType = {1}, Method = {2}, Class = {3}.", new Object[]{this.getClass(), method.getReturnType(), method.getName(), method.getDeclaringClass()});
        Object returnValue = this.invokeInternal(proxy, method, envelop);
        message.reply((Object)Envelop.success(returnValue));
    }

    @Override
    public void next(Object proxy, Method method, Message<Envelop> message, Vertx vertx) {
        Envelop envelop = (Envelop)message.body();
        this.getLogger().info("( Invoker Rpc ) Invoker = {0}, ReturnType = {1}, Method = {2}, Class = {3}.", new Object[]{this.getClass(), method.getReturnType(), method.getName(), method.getDeclaringClass()});
        Object returnValue = this.invokeInternal(proxy, method, envelop);
        this.nextEnvelop(vertx, method, Envelop.success(returnValue)).onComplete(Ux.handler(message));
    }
}

