/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.invoker;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.web._500ReturnNullException;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.invoker.AbstractInvoker;
import io.vertx.up.uca.invoker.InvokerUtil;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.Objects;

public class FutureInvoker
extends AbstractInvoker {
    @Override
    public void ensure(Class<?> returnType, Class<?> paramCls) {
        boolean valid = Future.class.isAssignableFrom(returnType) && paramCls == Envelop.class;
        InvokerUtil.verify(!valid, returnType, paramCls, this.getClass());
    }

    @Override
    public void invoke(Object proxy, Method method, Message<Envelop> message) {
        Envelop envelop = (Envelop)message.body();
        Class<?> returnType = method.getReturnType();
        Class<?> tCls = returnType.getComponentType();
        this.getLogger().info("( Invoker ) Invoker = {0}, ReturnType = {1}, Method = {2}, Class = {3}.", new Object[]{this.getClass(), returnType, method.getName(), method.getDeclaringClass()});
        if (Envelop.class == tCls) {
            Future result = (Future)Ut.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{envelop});
            Fn.out((boolean)Objects.isNull(result), _500ReturnNullException.class, (Object[])new Object[]{this.getClass(), method});
            result.onComplete(item -> message.reply(item.result()));
        } else {
            Future tResult = (Future)Ut.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{envelop});
            Fn.out((boolean)Objects.isNull(tResult), _500ReturnNullException.class, (Object[])new Object[]{this.getClass(), method});
            tResult.onComplete(Ux.handler(message));
        }
    }

    @Override
    public void next(Object proxy, Method method, Message<Envelop> message, Vertx vertx) {
        Envelop envelop = (Envelop)message.body();
        Class<?> returnType = method.getReturnType();
        Class<?> tCls = returnType.getComponentType();
        this.getLogger().info("( Invoker Rpc ) Invoker = {0}, ReturnType = {1}, Method = {2}, Class = {3}.", new Object[]{this.getClass(), returnType, method.getName(), method.getDeclaringClass()});
        if (Envelop.class == tCls) {
            Future future = (Future)InvokerUtil.invoke(proxy, method, envelop);
            future.compose(this.nextEnvelop(vertx, method)).onComplete(Ux.handler(message));
        } else {
            Future future = (Future)InvokerUtil.invoke(proxy, method, envelop);
            future.compose(this.nextEnvelop(vertx, method)).onComplete(Ux.handler(message));
        }
    }
}

