/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.center;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.tp.plugin.job.JobClient;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.log.Debugger;
import io.vertx.up.uca.job.center.AbstractAgha;

class OnceAgha
extends AbstractAgha {
    OnceAgha() {
    }

    @Override
    public Future<Long> begin(Mission mission) {
        this.moveOn(mission, true);
        Promise promise = Promise.promise();
        long jobId = this.interval().startAt((Handler<Long>)((Handler)timeId -> this.working(mission, () -> {
            promise.tryComplete(timeId);
            this.moveOn(mission, true);
        })));
        JobClient.bind(jobId, mission.getCode());
        if (Debugger.onJobBooting()) {
            this.getLogger().info("[ Job ] `{0}` The scheduler will start after {1} ms, then scheduled duration {2} (-1 means ONCE) ms in each, timerId = {3}", new Object[]{mission.getCode(), String.valueOf(0), String.valueOf(-1), String.valueOf(jobId)});
        }
        return promise.future();
    }
}

