/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.ActionFetch;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.DeleteConditionStep;

class ActionDelete
extends AbstractAction {
    private final transient ActionFetch fetch;

    ActionDelete(JqAnalyzer analyzer) {
        super(analyzer);
        this.fetch = new ActionFetch(analyzer);
    }

    <T> Future<T> deleteAsync(T entity) {
        Condition condition = this.analyzer.conditionUk(entity);
        return ((Future)this.dao().deleteByCondition(condition)).compose(rows -> Future.succeededFuture((Object)entity));
    }

    <T> T delete(T entity) {
        Condition condition = this.analyzer.conditionUk(entity);
        DeleteConditionStep deleteStep = this.context().deleteFrom(this.analyzer.table()).where(condition);
        int rows = deleteStep.execute();
        this.logging("[ Jq ] delete(T) executed rows: {0}", String.valueOf(rows));
        return entity;
    }

    <T> Future<List<T>> deleteAsync(List<T> entity) {
        return this.dsl.executeBlocking(h -> h.complete(this.delete(entity)));
    }

    <T> List<T> delete(List<T> entity) {
        Objects.requireNonNull(entity);
        if (entity.isEmpty()) {
            return entity;
        }
        ArrayList batchOps = new ArrayList();
        entity.stream().map(item -> {
            Condition condition = this.analyzer.conditionUk(item);
            return this.context().delete(this.analyzer.table()).where(condition);
        }).forEach(batchOps::add);
        int[] rows = this.context().batch(batchOps).execute();
        long updated = Arrays.stream(rows).filter(value -> 1 == value).count();
        this.logging("[ Jq ] delete(List<T>) executed rows: {0}/{1}", String.valueOf(updated), String.valueOf(rows.length));
        return entity;
    }

    <T, ID> Boolean deleteById(Collection<ID> ids) {
        Objects.requireNonNull(ids);
        if (ids.isEmpty()) {
            return Boolean.TRUE;
        }
        ArrayList batchOps = new ArrayList();
        ids.stream().map(id -> {
            Condition condition = this.analyzer.conditionId(id);
            return this.context().delete(this.analyzer.table()).where(condition);
        }).forEach(batchOps::add);
        int[] rows = this.context().batch(batchOps).execute();
        long updated = Arrays.stream(rows).filter(value -> 1 == value).count();
        this.logging("[ Jq ] deleteById(Collection<ID>) executed rows: {0}/{1}", String.valueOf(updated), String.valueOf(rows.length));
        return Boolean.TRUE;
    }

    <T, ID> Future<Boolean> deleteByIdAsync(Collection<ID> ids) {
        Objects.requireNonNull(ids);
        return ((Future)this.dao().deleteByIds(ids)).compose(rows -> {
            this.logging("[ Jq ] deleteByIdAsync(Collection<ID>) executed rows: {0}/{1}", String.valueOf(rows), String.valueOf(ids.size()));
            return Future.succeededFuture((Object)Boolean.TRUE);
        });
    }

    <T, ID> Future<Boolean> deleteByAsync(JsonObject criteria) {
        if (Ut.isNil((JsonObject)criteria)) {
            this.logging("[ Jq ] deleteByAsync(JsonObject) Ignore because the condition is null: {0}", criteria);
            return Ux.future(Boolean.TRUE);
        }
        return this.fetch.fetchAsync(criteria).compose(list -> this.deleteAsync((List)list).compose(nil -> Future.succeededFuture((Object)Boolean.TRUE)));
    }

    <T, ID> Boolean deleteBy(JsonObject criteria) {
        if (Ut.isNil((JsonObject)criteria)) {
            this.logging("[ Jq ] deleteBy(JsonObject) Ignore because the condition is null: {0}", criteria);
            return Boolean.TRUE;
        }
        List entities = this.fetch.fetch(criteria);
        this.delete(entities);
        return Boolean.TRUE;
    }
}

