/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.condition.JooqCond;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.ActionQr;
import io.vertx.up.uca.jooq.JqAnalyzer;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Operator;
import org.jooq.SelectConditionStep;
import org.jooq.SelectWhereStep;

class ActionFetch
extends AbstractAction {
    private final transient ActionQr qr;

    ActionFetch(JqAnalyzer analyzer) {
        super(analyzer);
        this.qr = new ActionQr(analyzer);
    }

    <T> Future<List<T>> fetchAllAsync() {
        return ((Future)this.dao().findAll()).compose(list -> {
            this.logging("[ Jq ] fetchAllAsync() queried rows: {0}", String.valueOf(list.size()));
            return Future.succeededFuture((Object)list);
        });
    }

    <T> List<T> fetchAll() {
        SelectWhereStep selectStep = this.context().selectFrom(this.analyzer.table());
        List list = selectStep.fetchInto(this.analyzer.type());
        this.logging("[ Jq ] fetchAll() queried rows: {0}", String.valueOf(list.size()));
        return list;
    }

    <T, ID> Future<T> fetchByIdAsync(ID id) {
        return ((Future)this.dao().findOneById(id)).compose(queried -> {
            this.logging("[ Jq ] fetchByIdAsync(ID) by id: {1}, queried record: {0}", queried, id);
            return Future.succeededFuture((Object)queried);
        });
    }

    <T, ID> T fetchById(ID id) {
        SelectConditionStep selectStep = this.context().selectFrom(this.analyzer.table()).where(this.analyzer.conditionId(id));
        Object queried = selectStep.fetchOneInto(this.analyzer.type());
        this.logging("[ Jq ] fetchByIdAsync(ID) by id: {1}, queried record: {0}", queried, id);
        return (T)queried;
    }

    <T> Future<List<T>> fetchAsync(String field, Object value) {
        Condition condition = this.analyzer.conditionField(field, value);
        return ((Future)this.dao().findManyByCondition(condition)).compose(list -> {
            this.logging("[ Jq ] fetchAsync(String, Object) condition: \"{1}\", queried rows: {0}", String.valueOf(list.size()), condition);
            return Future.succeededFuture((Object)list);
        });
    }

    <T> List<T> fetch(String field, Object value) {
        Condition condition = this.analyzer.conditionField(field, value);
        SelectConditionStep selectStep = this.context().selectFrom(this.analyzer.table()).where(condition);
        List list = selectStep.fetchInto(this.analyzer.type());
        this.logging("[ Jq ] fetch(String, Object) condition: \"{1}\", queried rows: {0}", String.valueOf(list.size()), condition);
        return list;
    }

    <T> Future<List<T>> fetchAsync(JsonObject criteria) {
        return this.qr.searchAsync(criteria).compose(list -> {
            this.logging("[ Jq ] fetchAsync(JsonObject) condition json: \"{1}\", queried rows: {0}", String.valueOf(list.size()), criteria);
            return Future.succeededFuture((Object)list);
        });
    }

    <T> List<T> fetch(JsonObject criteria) {
        List list = this.qr.search(criteria);
        this.logging("[ Jq ] fetch(JsonObject) condition json: \"{1}\", queried rows: {0}", String.valueOf(list.size()), criteria);
        return list;
    }

    <T> Future<T> fetchOneAsync(String field, Object value) {
        Condition condition = this.analyzer.conditionField(field, value);
        return ((Future)this.dao().findOneByCondition(condition)).compose(queried -> {
            this.logging("[ Jq ] fetchOneAsync(String, Object) condition: \"{1}\", queried record: {0}", queried, condition);
            return Future.succeededFuture((Object)queried);
        });
    }

    <T> T fetchOne(String field, Object value) {
        Condition condition = this.analyzer.conditionField(field, value);
        SelectConditionStep selectStep = this.context().selectFrom(this.analyzer.table()).where(condition);
        Object queried = selectStep.fetchOneInto(this.analyzer.type());
        this.logging("[ Jq ] fetchOne(String, Object) condition: \"{1}\", queried record: {0}", queried, condition);
        return (T)queried;
    }

    <T> Future<T> fetchOneAsync(JsonObject criteria) {
        Condition condition = JooqCond.transform((JsonObject)criteria, (Operator)Operator.AND, this.analyzer::column);
        return ((Future)this.dao().findOneByCondition(condition)).compose(queried -> {
            this.logging("[ Jq ] fetchOneAsync(JsonObject) condition: \"{1}\", queried record: {0}", queried, condition);
            return Future.succeededFuture((Object)queried);
        });
    }

    <T> T fetchOne(JsonObject criteria) {
        Condition condition = JooqCond.transform((JsonObject)criteria, (Operator)Operator.AND, this.analyzer::column);
        SelectConditionStep selectStep = this.context().selectFrom(this.analyzer.table()).where(condition);
        Object queried = selectStep.fetchOneInto(this.analyzer.type());
        this.logging("[ Jq ] fetchOne(JsonObject) condition: \"{1}\", queried record: {0}", queried, condition);
        return (T)queried;
    }
}

