/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.ActionFetch;
import io.vertx.up.uca.jooq.ActionInsert;
import io.vertx.up.uca.jooq.ActionUpdate;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;

class ActionUpsert
extends AbstractAction {
    private final transient ActionFetch fetch;
    private final transient ActionUpdate update;
    private final transient ActionInsert insert;

    ActionUpsert(JqAnalyzer analyzer) {
        super(analyzer);
        this.fetch = new ActionFetch(analyzer);
        this.update = new ActionUpdate(analyzer);
        this.insert = new ActionInsert(analyzer);
    }

    <T, ID> Future<T> upsertAsync(ID id, T updated) {
        return this.execAsync(this.fetch.fetchByIdAsync(id), updated);
    }

    <T> Future<T> upsertAsync(JsonObject criteria, T updated) {
        return this.execAsync(this.fetch.fetchOneAsync(criteria), updated);
    }

    <T, ID> T upsert(ID id, T updated) {
        return this.exec(this.fetch.fetchById(id), updated);
    }

    <T> T upsert(JsonObject criteria, T updated) {
        return this.exec(this.fetch.fetchOne(criteria), updated);
    }

    <T> List<T> upsert(JsonObject criteria, List<T> updated, BiPredicate<T, T> finder) {
        List original = this.fetch.fetch(criteria);
        ConcurrentMap compared = this.compared(original, updated, finder);
        ArrayList resultList = new ArrayList();
        resultList.addAll(this.insert.insert((List)compared.get(ChangeFlag.ADD)));
        resultList.addAll(this.update.update((List)compared.get(ChangeFlag.UPDATE)));
        return resultList;
    }

    <T> Future<List<T>> upsertAsync(JsonObject criteria, List<T> updated, BiPredicate<T, T> finder) {
        return this.fetch.fetchAsync(criteria).compose(original -> {
            ConcurrentMap compared = this.compared((List)original, updated, finder);
            ArrayList futures = new ArrayList();
            futures.add(this.insert.insertAsync((List)compared.get(ChangeFlag.ADD)));
            futures.add(this.update.updateAsync((List)compared.get(ChangeFlag.UPDATE)));
            return Ux.thenCombineArrayT(futures);
        });
    }

    <T> ConcurrentMap<ChangeFlag, List<T>> compared(List<T> original, List<T> updated, BiPredicate<T, T> finder) {
        final ArrayList addQueue = new ArrayList();
        final ArrayList updateQueue = new ArrayList();
        updated.forEach(newRecord -> {
            Object found = Ut.elementFind((List)original, oldRecord -> finder.test(oldRecord, newRecord));
            if (Objects.isNull(found)) {
                addQueue.add(newRecord);
            } else {
                Object combine = this.analyzer.copyEntity(found, newRecord);
                updateQueue.add(combine);
            }
        });
        return new ConcurrentHashMap<ChangeFlag, List<T>>(){
            {
                this.put(ChangeFlag.ADD, addQueue);
                this.put(ChangeFlag.UPDATE, updateQueue);
            }
        };
    }

    private <T> Future<T> execAsync(Future<T> queried, T updated) {
        return queried.compose(previous -> {
            if (Objects.isNull(previous)) {
                return this.insert.insertAsync(updated);
            }
            Object combine = this.analyzer.copyEntity(previous, updated);
            return this.update.updateAsync(combine);
        });
    }

    private <T> T exec(T queried, T updated) {
        if (Objects.isNull(queried)) {
            return this.insert.insert(updated);
        }
        T combine = this.analyzer.copyEntity(queried, updated);
        return this.update.update(combine);
    }
}

