/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.jooq.AbstractAggregator;
import io.vertx.up.uca.jooq.JqAnalyzer;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Condition;
import org.jooq.Field;

class AggregatorCount
extends AbstractAggregator {
    private static final String FIELD_COUNT = "COUNT";

    AggregatorCount(JqAnalyzer analyzer) {
        super(analyzer);
    }

    Long count() {
        Long rows = this.context().fetchCount(this.analyzer.table());
        this.logging("[ Jq ] count() rows: {0}", String.valueOf(rows));
        return rows;
    }

    Future<Long> countAsync() {
        return this.dsl.executeBlocking(h -> h.complete((Object)this.count()));
    }

    Long count(JsonObject criteria) {
        Condition condition = this.analyzer.condition(criteria);
        Long rows = this.context().fetchCount(this.analyzer.table(), condition);
        this.logging("[ Jq ] count(JsonObject) rows: {0}", String.valueOf(rows));
        return rows;
    }

    <T> Future<Long> countAsync(JsonObject criteria) {
        return this.dsl.executeBlocking(h -> h.complete((Object)this.count(criteria)));
    }

    ConcurrentMap<String, Integer> countBy(JsonObject criteria, String groupField) {
        String primary = this.analyzer.primary();
        Field countField = this.analyzer.column(primary).count().as(FIELD_COUNT);
        return this.aggregateBy(countField, criteria, groupField);
    }

    JsonArray countBy(JsonObject criteria, String ... groupFields) {
        String primary = this.analyzer.primary();
        Field countField = this.analyzer.column(primary).count().as(FIELD_COUNT);
        return this.aggregateBy(countField, criteria, groupFields);
    }
}

