/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.up.uca.jooq.JqAnalyzer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Field;
import org.jooq.impl.DSL;

class JoinAlias {
    private final transient ConcurrentMap<String, String> fieldTable = new ConcurrentHashMap<String, String>();
    private final transient ConcurrentMap<String, Field> fieldMap = new ConcurrentHashMap<String, Field>();
    private final transient ConcurrentMap<String, Set<String>> columnField = new ConcurrentHashMap<String, Set<String>>();

    JoinAlias() {
    }

    Field field(String field, String prefix) {
        Field original = (Field)this.fieldMap.get(field);
        return DSL.field((String)(prefix + "." + original.getName()));
    }

    Field field(String field) {
        Field found = (Field)this.fieldMap.get(field);
        return Objects.isNull(found) ? null : found;
    }

    String table(String field) {
        return this.fieldTable.getOrDefault(field, "");
    }

    ConcurrentMap<String, Set<String>> mapColumn() {
        return this.columnField;
    }

    void addDao(JqAnalyzer analyzer, String table, String tableAlias) {
        ConcurrentMap<String, Field> fields = analyzer.columns();
        for (String fieldName : fields.keySet()) {
            Field field = (Field)fields.get(fieldName);
            this.fieldMap.put(fieldName, field);
            if (this.fieldTable.containsKey(field.getName())) continue;
            this.fieldTable.put(field.getName(), tableAlias);
            this.addAlias(table, field, fieldName);
        }
    }

    void addAlias(JqAnalyzer analyzer, String table, String field, String alias) {
        Field column = analyzer.column(field);
        this.addAlias(table, column, alias);
        this.fieldMap.put(alias, column);
    }

    private void addAlias(String table, Field column, String alias) {
        Set<String> fields;
        String key = "\"" + table + "\".\"" + column.getName() + "\"";
        String hashKey = key.toUpperCase();
        if (this.columnField.containsKey(hashKey)) {
            fields = (Set)this.columnField.get(hashKey);
        } else {
            fields = new HashSet();
            this.columnField.put(hashKey, fields);
        }
        fields.add(alias);
        this.columnField.put(hashKey, fields);
    }
}

