/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.uca.jooq.JoinSearch;
import io.vertx.up.uca.jooq.JoinStore;
import io.vertx.up.uca.jooq.JoinUnique;
import io.vertx.up.uca.jooq.JoinWriter;
import io.vertx.up.unity.Ux;
import java.util.Set;

class JoinEngine {
    private final transient JoinStore store = new JoinStore();
    private final transient JoinSearch search = new JoinSearch(this.store);
    private final transient JoinUnique unique = new JoinUnique(this.store);
    private final transient JoinWriter writer = new JoinWriter(this.store);

    JoinEngine() {
    }

    <T> JoinEngine add(Class<T> daoCls, String field) {
        this.store.add(daoCls, field);
        return this;
    }

    <T> JoinEngine alias(Class<?> daoCls, String field, String alias) {
        this.store.alias(daoCls, field, alias);
        return this;
    }

    <T> JoinEngine join(Class<?> daoCls, String field) {
        this.store.join(daoCls, field);
        return this;
    }

    <T> JoinEngine pojo(Class<?> daoCls, String pojo) {
        this.store.pojo(daoCls, pojo);
        return this;
    }

    Set<String> fieldFirst() {
        return this.store.metaFirstField();
    }

    Future<JsonObject> fetchById(String key, boolean isASub, String field) {
        return this.unique.fetchById(key, isASub, field);
    }

    Future<Boolean> deleteById(String key) {
        return this.writer.deleteById(key);
    }

    Future<JsonObject> insert(JsonObject data, String field) {
        return this.writer.insert(data, field);
    }

    Future<JsonObject> update(String key, JsonObject data, String field) {
        return this.writer.update(key, data, field);
    }

    Future<JsonObject> searchAsync(Qr qr, Mojo mojo) {
        JsonObject response = new JsonObject();
        JsonArray data = this.search.searchA(qr, mojo);
        response.put("list", (Object)data);
        Long counter = this.search.count(qr);
        response.put("count", (Object)counter);
        return Ux.future(response);
    }

    JsonArray searchArray(Qr qr, Mojo mojo) {
        return this.search.searchA(qr, mojo);
    }

    Future<Long> countAsync(Qr qr) {
        return Future.succeededFuture((Object)this.search.count(qr));
    }
}

