/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqDsl;
import io.vertx.tp.plugin.jooq.condition.JooqCond;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.uca.jooq.JoinStore;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.JqEdge;
import io.vertx.up.uca.jooq.util.JqOut;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectWhereStep;
import org.jooq.Table;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;

class JoinSearch {
    private final transient JoinStore store;

    JoinSearch(JoinStore store) {
        this.store = store;
    }

    Long count(Qr qr) {
        JooqDsl dsl = this.store.metaDsl();
        DSLContext context = dsl.context();
        Table<Record> table = this.getTable();
        if (Objects.isNull(table)) {
            throw new RuntimeException("Table null issue! ");
        }
        Field field = this.store.field();
        SelectJoinStep started = context.select((SelectField)field).from(table);
        if (null != qr.getCriteria()) {
            Condition condition = JooqCond.transform((JsonObject)qr.getCriteria().toJson(), this.store::metaColumn, this.store::metaTable);
            started.where(condition);
        }
        return context.fetchCount((Select)started);
    }

    JsonArray searchA(Qr qr, Mojo mojo) {
        JooqDsl dsl = this.store.metaDsl();
        DSLContext context = dsl.context();
        Table<Record> table = this.getTable();
        if (Objects.isNull(table)) {
            throw new RuntimeException("Table null issue! ");
        }
        SelectWhereStep started = context.selectFrom(table);
        if (null != qr.getCriteria()) {
            Condition condition = JooqCond.transform((JsonObject)qr.getCriteria().toJson(), this.store::metaColumn, this.store::metaTable);
            started.where(condition);
        }
        if (null != qr.getSorter()) {
            List orders = JooqCond.orderBy((Sorter)qr.getSorter(), this.store::metaColumn, this.store::metaTable);
            started.orderBy((Collection)orders);
        }
        if (null != qr.getPager()) {
            Pager pager = qr.getPager();
            started.offset(pager.getStart()).limit(pager.getSize());
        }
        Result records = started.fetch();
        Result result = started.fetch();
        Set projectionSet = qr.getProjection();
        JsonArray projection = Objects.isNull(projectionSet) ? new JsonArray() : Ut.toJArray((Set)projectionSet);
        return JqOut.toJoin((List<Record>)records, projection, this.store.mapColumn(), mojo);
    }

    private Table<Record> getTable() {
        if (this.store.noPrefix()) {
            return null;
        }
        List<String> tables = this.store.tables();
        Table<Record> first = this.store.tableRecord();
        if (this.store.hasTable()) {
            return first;
        }
        int size = tables.size();
        Table<Record> record = this.store.tableRecord(0);
        TableOnConditionStep<Record> conditionStep = this.buildCondition(first, record, this.store.edge(0));
        for (int idx = 1; idx < size; ++idx) {
            Table<Record> next = this.store.tableRecord(idx);
            conditionStep = this.buildCondition((Table<Record>)conditionStep, next, this.store.edge(idx));
        }
        return conditionStep;
    }

    private TableOnConditionStep<Record> buildCondition(Table<Record> from, Table<Record> to, JqEdge edge) {
        String majorField = edge.getFromField();
        JqAnalyzer major = this.store.analyzer(edge.getFromTable());
        Field hitted = major.column(majorField);
        String fromPrefix = this.store.metaPrefix(edge.getFromTable());
        Field hittedField = DSL.field((String)(fromPrefix + "." + hitted.getName()));
        String toField = edge.getToField();
        JqAnalyzer toTable = this.store.analyzer(edge.getToTable());
        Field joined = toTable.column(toField);
        String toPrefix = this.store.metaPrefix(edge.getToTable());
        Field joinedField = DSL.field((String)(toPrefix + "." + joined.getName()));
        return from.leftJoin(to).on(hittedField.eq(joinedField));
    }
}

