/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqDsl;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.up.atom.Kv;
import io.vertx.up.exception.web._501NotSupportException;
import io.vertx.up.uca.jooq.JoinAlias;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.JqEdge;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

class JoinStore {
    private final transient ConcurrentMap<Class<?>, JqAnalyzer> daoAnalyzer = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, String> tablePrefix = new ConcurrentHashMap<String, String>();
    private final transient ConcurrentMap<Class<?>, String> daoTable = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, Class<?>> tableDao = new ConcurrentHashMap();
    private final transient List<String> tableList = new ArrayList<String>();
    private final transient List<JqEdge> edgeList = new ArrayList<JqEdge>();
    private final transient JoinAlias alias = new JoinAlias();
    private transient Kv<String, String> first;
    private transient JqAnalyzer firstAnalyzer;
    private transient Class<?> firstDao;

    JoinStore() {
    }

    <T> void join(Class<?> daoCls, String field) {
        if (2 < this.daoAnalyzer.size()) {
            throw new RuntimeException("Join table counter limitation! ");
        }
        this.addDao(daoCls);
        String toTable = (String)this.daoTable.get(daoCls);
        this.tableList.add(toTable);
        JqEdge edge = new JqEdge();
        edge.setFrom((String)this.first.getKey(), (String)this.first.getValue());
        edge.setTo(toTable, field);
        this.edgeList.add(edge);
    }

    <T> void add(Class<?> daoCls, String field) {
        this.addDao(daoCls);
        String firstTable = (String)this.daoTable.get(daoCls);
        this.first = Kv.create((Object)firstTable, (Object)field);
        this.firstDao = daoCls;
        this.firstAnalyzer = (JqAnalyzer)this.daoAnalyzer.get(daoCls);
    }

    <T> void alias(Class<?> daoCls, String field, String alias) {
        String tableName = this.daoTable.getOrDefault(daoCls, null);
        if (Objects.nonNull(tableName)) {
            JqAnalyzer analyzer = (JqAnalyzer)this.daoAnalyzer.get(daoCls);
            this.alias.addAlias(analyzer, tableName, field, alias);
        }
    }

    <T> void pojo(Class<?> daoCls, String pojo) {
        JqAnalyzer analyzer = (JqAnalyzer)this.daoAnalyzer.get(daoCls);
        if (Objects.nonNull(analyzer)) {
            analyzer.on(pojo, daoCls);
        }
    }

    Set<String> metaFirstField() {
        return this.firstAnalyzer.fieldSet();
    }

    String metaTable(String field) {
        return this.alias.table(field);
    }

    Field metaColumn(String field) {
        return this.alias.field(field);
    }

    JooqDsl metaDsl() {
        return this.firstAnalyzer.dsl();
    }

    String metaPrefix(String table) {
        Objects.requireNonNull(table);
        return (String)this.tablePrefix.get(table);
    }

    boolean noPrefix() {
        return this.tablePrefix.isEmpty();
    }

    boolean hasTable() {
        return this.tableList.isEmpty();
    }

    JqAnalyzer analyzer(String name) {
        Class daoCls = (Class)this.tableDao.get(name);
        return (JqAnalyzer)this.daoAnalyzer.get(daoCls);
    }

    UxJooq jooq() {
        return Ux.Jooq.on(this.firstDao);
    }

    UxJooq childJooq() {
        Set analyzers = this.daoAnalyzer.keySet().stream().filter(item -> !item.equals(this.firstDao)).collect(Collectors.toSet());
        if (1 == analyzers.size()) {
            Class daoCls = (Class)analyzers.iterator().next();
            return Ux.Jooq.on(daoCls);
        }
        throw new _501NotSupportException(this.getClass());
    }

    Set<String> childKeySet() {
        Collection analyzers = this.daoAnalyzer.values().stream().filter(item -> !item.equals(this.firstAnalyzer)).collect(Collectors.toSet());
        if (1 == analyzers.size()) {
            JqAnalyzer analyzer = (JqAnalyzer)analyzers.iterator().next();
            return analyzer.primarySet();
        }
        throw new _501NotSupportException(this.getClass());
    }

    ConcurrentMap<String, Set<String>> mapColumn() {
        return this.alias.mapColumn();
    }

    Field field(String field) {
        String prefix = (String)this.tablePrefix.get(this.first.getKey());
        return this.alias.field(field, prefix);
    }

    Field field() {
        return this.field((String)this.first.getValue());
    }

    JqEdge edge(int index) {
        return this.edgeList.get(index);
    }

    List<String> tables() {
        return this.tableList;
    }

    Table<Record> tableRecord() {
        return this.tableRecord((String)this.first.getKey());
    }

    Table<Record> tableRecord(int index) {
        String table = this.tableList.get(index);
        return this.tableRecord(table);
    }

    Table<Record> tableRecord(String tableName) {
        String alias = (String)this.tablePrefix.get(tableName);
        return DSL.table((Name)DSL.name((String)tableName)).as(DSL.name((String)alias));
    }

    JsonObject dataJoin(JsonObject record) {
        Objects.requireNonNull(record);
        JsonObject joined = new JsonObject();
        String firstField = (String)this.first.getValue();
        Object value = record.getValue(firstField);
        if (Objects.nonNull(value)) {
            this.edgeList.forEach(edge -> {
                String toField = edge.getToField();
                if (Objects.nonNull(toField)) {
                    joined.put(toField, value);
                }
            });
        }
        return joined;
    }

    private <T> void addDao(Class<T> daoCls) {
        JooqDsl dsl = JooqInfix.getDao(daoCls);
        JqAnalyzer analyzer = JqAnalyzer.create(dsl);
        String tableName = analyzer.table().getName();
        this.daoAnalyzer.put(daoCls, analyzer);
        this.daoTable.put(daoCls, tableName);
        this.tableDao.put(tableName, daoCls);
        int size = this.daoAnalyzer.size();
        String tableAlias = "T" + size;
        this.tablePrefix.put(tableName, DSL.table((String)tableAlias).getName());
        this.alias.addDao(analyzer, tableName, tableAlias);
    }
}

