/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.jooq.JoinStore;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.util.Objects;

class JoinUnique {
    private final transient JoinStore store;

    JoinUnique(JoinStore store) {
        this.store = store;
    }

    Future<JsonObject> fetchById(String key, boolean isASub, String field) {
        UxJooq jooq = this.store.jooq();
        return jooq.fetchJByIdAsync(key).compose(response -> {
            if (isASub) {
                return this.fetchA((JsonObject)response).compose(data -> {
                    response.put(field, data);
                    return Ux.future(response);
                });
            }
            return this.fetchJ((JsonObject)response).compose(data -> {
                response.put(field, data);
                return Ux.future(response);
            });
        });
    }

    private Future<JsonArray> fetchA(JsonObject response) {
        UxJooq childJq = this.store.childJooq();
        if (Objects.nonNull(childJq)) {
            JsonObject joined = this.store.dataJoin(response);
            return childJq.fetchJAsync(joined);
        }
        return Ux.futureA();
    }

    private Future<JsonObject> fetchJ(JsonObject response) {
        UxJooq childJq = this.store.childJooq();
        if (Objects.nonNull(childJq)) {
            JsonObject joined = this.store.dataJoin(response);
            return childJq.fetchJOneAsync(joined);
        }
        return Ux.futureJ();
    }
}

