/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.uca.jooq.JoinStore;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

class JoinWriter {
    private final transient JoinStore store;

    JoinWriter(JoinStore store) {
        this.store = store;
    }

    Future<Boolean> deleteById(String key) {
        UxJooq jooq = this.store.jooq();
        return jooq.fetchJByIdAsync(key).compose(response -> this.deleteChild((JsonObject)response).compose(nil -> jooq.deleteByIdAsync(key)));
    }

    Future<JsonObject> insert(JsonObject data, String field) {
        UxJooq jooq = this.store.jooq();
        return jooq.insertJAsync(data).compose(response -> {
            JsonArray record = this.valueNorm(data, field);
            return this.upsertChild((JsonObject)response, record).compose(items -> {
                response.put(field, items);
                return Ux.future(response);
            });
        });
    }

    Future<JsonObject> update(String key, JsonObject data, String field) {
        UxJooq jooq = this.store.jooq();
        return jooq.updateJAsync(key, data).compose(response -> {
            JsonArray record = this.valueNorm(data, field);
            return this.upsertChild((JsonObject)response, record).compose(items -> {
                response.put(field, items);
                return Ux.future(response);
            });
        });
    }

    private Future<Boolean> deleteChild(JsonObject response) {
        UxJooq childJq = this.store.childJooq();
        if (Objects.nonNull(childJq)) {
            JsonObject joined = this.store.dataJoin(response);
            return childJq.deleteByAsync(joined).compose(nil -> Ux.futureT());
        }
        return Ux.future(Boolean.FALSE);
    }

    private Future<JsonArray> upsertChild(JsonObject response, JsonArray current) {
        UxJooq childJq = this.store.childJooq();
        if (Objects.nonNull(childJq)) {
            JsonObject joined = this.store.dataJoin(response);
            return childJq.fetchJAsync(joined).compose(original -> {
                JsonObject child = this.valueNorm(response, joined);
                Ut.itJArray((JsonArray)current).forEach(each -> each.mergeIn(child));
                ConcurrentMap<ChangeFlag, JsonArray> compared = Ux.compareJ(original, current, this.store.childKeySet());
                ArrayList<Future<JsonArray>> futures = new ArrayList<Future<JsonArray>>();
                futures.add(childJq.insertJAsync((JsonArray)compared.get(ChangeFlag.ADD)));
                futures.add(childJq.updateAsync((JsonArray)compared.get(ChangeFlag.UPDATE)).compose(Ux::futureA));
                futures.add(childJq.deleteJAsync((JsonArray)compared.get(ChangeFlag.DELETE)));
                return Ux.thenCombineArray(futures);
            });
        }
        return Ux.futureA();
    }

    private JsonArray valueNorm(JsonObject data, String field) {
        Object childValue = data.getValue(field);
        JsonArray dataArray = new JsonArray();
        if (Objects.nonNull(childValue)) {
            if (childValue instanceof JsonObject) {
                dataArray.add(childValue);
            } else if (childValue instanceof JsonArray) {
                dataArray.addAll((JsonArray)childValue);
            }
        }
        return dataArray;
    }

    private JsonObject valueNorm(JsonObject response, JsonObject joined) {
        Ut.ifJAssign((JsonObject)response, (String[])new String[]{"createdBy", "createdAt", "updatedBy", "updatedAt", "sigma", "language", "active"}).apply(joined);
        return joined;
    }
}

