/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.uca.jooq.ActionGroup;
import io.vertx.up.uca.jooq.AggregatorAvg;
import io.vertx.up.uca.jooq.AggregatorCount;
import io.vertx.up.uca.jooq.AggregatorMax;
import io.vertx.up.uca.jooq.AggregatorMin;
import io.vertx.up.uca.jooq.AggregatorSum;
import io.vertx.up.uca.jooq.JqAnalyzer;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

class JqAggregator {
    private final transient AggregatorCount counter;
    private final transient AggregatorSum sum;
    private final transient AggregatorMax max;
    private final transient AggregatorMin min;
    private final transient AggregatorAvg avg;
    private final transient ActionGroup group;

    private JqAggregator(JqAnalyzer analyzer) {
        this.group = new ActionGroup(analyzer);
        this.counter = new AggregatorCount(analyzer);
        this.sum = new AggregatorSum(analyzer);
        this.min = new AggregatorMin(analyzer);
        this.max = new AggregatorMax(analyzer);
        this.avg = new AggregatorAvg(analyzer);
    }

    public static JqAggregator create(JqAnalyzer analyzer) {
        return new JqAggregator(analyzer);
    }

    Long count(Qr qr) {
        return this.count(null == qr.getCriteria() ? new JsonObject() : qr.getCriteria().toJson());
    }

    <T> Future<Long> countAsync(Qr qr) {
        return this.countAsync(null == qr.getCriteria() ? new JsonObject() : qr.getCriteria().toJson());
    }

    Long countAll() {
        return this.counter.count();
    }

    Future<Long> countAllAsync() {
        return this.counter.countAsync();
    }

    <T> Long count(JsonObject criteria) {
        return this.counter.count(criteria);
    }

    <T> Future<Long> countAsync(JsonObject criteria) {
        return this.counter.countAsync(criteria);
    }

    <T> ConcurrentMap<String, Integer> countBy(JsonObject criteria, String field) {
        return this.counter.countBy(criteria, field);
    }

    <T> JsonArray countBy(JsonObject criteria, String ... fields) {
        return this.counter.countBy(criteria, fields);
    }

    <T> ConcurrentMap<String, List<T>> group(String field) {
        return this.group.group(field);
    }

    <T> ConcurrentMap<String, List<T>> group(JsonObject criteria, String field) {
        return this.group.group(criteria, field);
    }

    BigDecimal sum(String field, JsonObject criteria) {
        return this.sum.sum(field, criteria);
    }

    ConcurrentMap<String, BigDecimal> sum(String field, JsonObject criteria, String groupField) {
        return this.sum.sum(field, criteria, groupField);
    }

    JsonArray sum(String field, JsonObject criteria, String ... groupFields) {
        return this.sum.sum(field, criteria, groupFields);
    }

    BigDecimal max(String field, JsonObject criteria) {
        return this.max.max(field, criteria);
    }

    ConcurrentMap<String, BigDecimal> max(String field, JsonObject criteria, String groupField) {
        return this.max.max(field, criteria, groupField);
    }

    JsonArray max(String field, JsonObject criteria, String ... groupFields) {
        return this.max.max(field, criteria, groupFields);
    }

    BigDecimal min(String field, JsonObject criteria) {
        return this.min.min(field, criteria);
    }

    ConcurrentMap<String, BigDecimal> min(String field, JsonObject criteria, String groupField) {
        return this.min.min(field, criteria, groupField);
    }

    JsonArray min(String field, JsonObject criteria, String ... groupFields) {
        return this.min.min(field, criteria, groupFields);
    }

    BigDecimal avg(String field, JsonObject criteria) {
        return this.avg.avg(field, criteria);
    }

    ConcurrentMap<String, BigDecimal> avg(String field, JsonObject criteria, String groupField) {
        return this.avg.avg(field, criteria, groupField);
    }

    JsonArray avg(String field, JsonObject criteria, String ... groupFields) {
        return this.avg.avg(field, criteria, groupFields);
    }
}

