/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.pojo.Mirror;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.uca.jooq.JoinEngine;
import io.vertx.up.uca.jooq.util.JqTool;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class UxJoin {
    private final transient JsonObject configuration = new JsonObject();
    private final transient JoinEngine joinder = new JoinEngine();
    private final transient ConcurrentMap<Class<?>, String> pojoMap = new ConcurrentHashMap();
    private transient Mojo merged = null;
    private transient Set<String> fieldSet = new HashSet<String>();

    public UxJoin(String file) {
        JsonObject config;
        if (Ut.notNil((String)file) && Ut.notNil((JsonObject)(config = Ut.ioJObject((String)file)))) {
            this.configuration.mergeIn(config);
        }
    }

    public <T> UxJoin add(Class<?> daoCls) {
        this.joinder.add(daoCls, this.translate(daoCls, "key"));
        return this;
    }

    public <T> UxJoin add(Class<?> daoCls, String field) {
        this.joinder.add(daoCls, this.translate(daoCls, field));
        return this;
    }

    public <T> UxJoin alias(Class<?> daoCls, String field, String alias) {
        this.joinder.alias(daoCls, field, alias);
        return this;
    }

    public <T> UxJoin alias(Class<?> daoCls, JsonObject fieldMap) {
        Ut.itJObject((JsonObject)fieldMap, (alias, field) -> this.alias(daoCls, (String)field, (String)alias));
        return this;
    }

    public <T> UxJoin pojo(Class<?> daoCls, String pojo) {
        Mojo created = Mirror.create(UxJoin.class).mount(pojo).mojo();
        this.pojoMap.put(daoCls, pojo);
        if (Objects.isNull(this.merged)) {
            this.merged = new Mojo();
        }
        this.merged.bind(created).bindColumn(created.getInColumn());
        return this;
    }

    public <T> UxJoin join(Class<?> daoCls) {
        this.joinder.join(daoCls, this.translate(daoCls, "key"));
        return this;
    }

    public <T> UxJoin join(Class<?> daoCls, String field) {
        this.joinder.join(daoCls, this.translate(daoCls, field));
        return this;
    }

    public Future<JsonObject> searchAsync(JsonObject params) {
        return this.searchAsync(this.toQr(params));
    }

    public Future<JsonObject> searchAsync(Qr qr) {
        this.pojoMap.forEach(this.joinder::pojo);
        return this.joinder.searchAsync(qr, this.merged);
    }

    public Future<Long> countAsync(JsonObject params) {
        return this.countAsync(this.toQr(params));
    }

    public Future<Long> countAsync(Qr qr) {
        this.pojoMap.forEach(this.joinder::pojo);
        return this.joinder.countAsync(qr);
    }

    public JsonArray fetch(Qr qr) {
        this.pojoMap.forEach(this.joinder::pojo);
        return this.joinder.searchArray(qr, this.merged);
    }

    public JsonArray fetch(JsonObject params) {
        return this.fetch(this.toQr(new JsonObject().put("criteria", (Object)params)));
    }

    public Future<JsonArray> fetchAsync(Qr qr) {
        return Ux.future(this.fetch(qr));
    }

    public Future<JsonArray> fetchAsync(JsonObject params) {
        return this.fetchAsync(this.toQr(new JsonObject().put("criteria", (Object)params)));
    }

    public Future<JsonObject> fetchByIdJAsync(String key, String field) {
        return this.joinder.fetchById(key, false, field);
    }

    public Future<JsonObject> fetchByIdAAsync(String key, String field) {
        return this.joinder.fetchById(key, true, field);
    }

    public Future<Boolean> removeByIdAsync(String key) {
        return this.joinder.deleteById(key);
    }

    public Future<JsonObject> insertAsync(JsonObject data, String field) {
        return this.joinder.insert(data, field);
    }

    public Future<JsonObject> updateAsync(String key, JsonObject data, String field) {
        return this.joinder.update(key, data, field);
    }

    private Qr toQr(JsonObject params) {
        return Objects.isNull(this.merged) ? Qr.create((JsonObject)params) : JqTool.qr(params, this.merged, this.joinder.fieldFirst());
    }

    private String translate(Class<?> daoCls, String field) {
        String pojoFile = (String)this.pojoMap.get(daoCls);
        if (Ut.isNil((String)pojoFile)) {
            return field;
        }
        Mojo mojo = Mirror.create(UxJoin.class).mount(pojoFile).mojo();
        if (Objects.isNull(mojo)) {
            return field;
        }
        String translated = (String)mojo.getIn().get(field);
        if (Ut.isNil((String)translated)) {
            return field;
        }
        return translated;
    }
}

