/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq.util;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.util.Ut;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jooq.Field;
import org.jooq.Record;

public class JqOut {
    public static <T> List<T> toResult(List<T> list, JsonArray projectionArray, JqAnalyzer analyzer) {
        Mojo mojo = analyzer.pojo();
        Set projections = Ut.toSet((JsonArray)projectionArray);
        return JqOut.toResult(list, projections, analyzer.type());
    }

    public static JsonArray toJoin(List<Record> records, JsonArray projection, ConcurrentMap<String, Set<String>> fields, Mojo mojo) {
        JsonArray joinResult = new JsonArray();
        records.forEach(record -> {
            int size = record.size();
            JsonObject data = new JsonObject();
            for (int idx = 0; idx < size; ++idx) {
                String key;
                Set fieldSet;
                Field field = record.field(idx);
                Object value = record.get(field);
                if (!Objects.nonNull(value) || !Objects.nonNull(fieldSet = (Set)fields.get(key = field.getQualifiedName().toString().toUpperCase()))) continue;
                fieldSet.forEach(resultField -> JqOut.putField(data, mojo, resultField, value));
            }
            joinResult.add((Object)data);
        });
        Set<String> projections = JqOut.getProjections(projection, mojo);
        return JqOut.toResult(joinResult, projections);
    }

    private static void putField(JsonObject data, Mojo mojo, String field, Object value) {
        BiConsumer<String, Object> executor = (resultField, valueData) -> {
            if (!data.containsKey(field)) {
                data.put(resultField, valueData);
            }
        };
        String resultField2 = field;
        if (Ut.notNil((String)resultField2) && !data.containsKey(resultField2)) {
            String hitField;
            if (Objects.nonNull(mojo) && Ut.notNil((String)(hitField = (String)mojo.getOut().get(resultField2)))) {
                resultField2 = hitField;
            }
            if ("key".equals(resultField2) && data.containsKey("key")) {
                return;
            }
            if (value instanceof Timestamp) {
                Date dateTime = (Date)value;
                executor.accept(resultField2, dateTime.toInstant());
            } else if (value instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)value;
                executor.accept(resultField2, decimal.doubleValue());
            } else {
                executor.accept(resultField2, value);
            }
        }
    }

    private static <T> List<T> toResult(List<T> list, Set<String> projections, Class<?> type) {
        if (!projections.isEmpty() && !list.isEmpty()) {
            String[] fields;
            for (String filtered : fields = Arrays.stream(Ut.fields(type)).map(java.lang.reflect.Field::getName).filter(Objects::nonNull).filter(item -> !projections.contains(item)).collect(Collectors.toSet()).toArray(new String[0])) {
                list.forEach(entity -> Ut.field((Object)entity, (String)filtered, null));
            }
        }
        return list;
    }

    private static JsonArray toResult(JsonArray data, Set<String> projections) {
        if (!projections.isEmpty() && !Ut.isNil((JsonArray)data)) {
            Ut.itJArray((JsonArray)data).forEach(record -> {
                Set<String> filters = new HashSet(record.fieldNames()).stream().filter(item -> !projections.contains(item)).collect(Collectors.toSet());
                filters.forEach(filtered -> record.remove(filtered));
            });
        }
        return data;
    }

    private static Set<String> getProjections(JsonArray projection, Mojo mojo) {
        HashSet<String> filters = new HashSet<String>();
        if (Objects.nonNull(mojo)) {
            projection.stream().filter(Objects::nonNull).map(field -> (String)field).map(field -> (String)mojo.getIn().get(field)).forEach(filters::add);
        }
        filters.addAll(projection.getList());
        return filters;
    }
}

