/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.monitor;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.ext.web.Router;
import io.vertx.up.uca.monitor.meansure.Quota;
import io.vertx.up.uca.monitor.meansure.QuotaConnect;
import io.vertx.up.uca.rs.Axis;
import java.util.concurrent.ConcurrentMap;

public class ServiceAxis
implements Axis<Router> {
    private final transient Vertx vertx;

    public ServiceAxis(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void mount(Router router) {
        if (QuotaConnect.monitor()) {
            HealthChecks health = HealthChecks.create((Vertx)this.vertx);
            ConcurrentMap<String, Quota> registryMap = Quota.getRegistry(this.vertx);
            registryMap.forEach((arg_0, arg_1) -> ((HealthChecks)health).register(arg_0, arg_1));
            HealthCheckHandler handler = HealthCheckHandler.createWithHealthChecks((HealthChecks)health);
            router.get(QuotaConnect.routePath()).order(1000000).produces("application/json").handler((Handler)handler);
        }
    }
}

