/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.monitor.meansure;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.monitor.meansure.Quota;
import io.vertx.up.uca.monitor.meansure.SessionQuota;
import io.vertx.up.uca.monitor.meansure.VerticleQuota;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class QuotaConnect {
    private static final boolean IS_MONITOR;
    private static final Node<JsonObject> node;
    private static final Annal LOGGER;
    static ConcurrentMap<String, Function<Vertx, Quota>> REGISTRY_CLS;
    private static String PATH;

    public static String routePath() {
        return PATH;
    }

    public static boolean monitor() {
        return IS_MONITOR;
    }

    static {
        node = (Node)Ut.instance(ZeroUniform.class, (Object[])new Object[0]);
        LOGGER = Annal.get(QuotaConnect.class);
        REGISTRY_CLS = new ConcurrentHashMap<String, Function<Vertx, Quota>>();
        JsonObject config = (JsonObject)node.read();
        if (config.containsKey("monitor")) {
            IS_MONITOR = true;
            REGISTRY_CLS.put("session", SessionQuota::new);
            REGISTRY_CLS.put("instance", VerticleQuota::new);
            String secure = Ut.visitString((JsonObject)config, (String[])new String[]{"monitor", "secure"});
            PATH = Ut.isNil((String)secure) ? "/zero/health*" : secure + "/zero/health*";
            JsonArray quotas = Ut.visitJArray((JsonObject)config, (String[])new String[]{"monitor", "quota"});
            if (!quotas.isEmpty()) {
                LOGGER.info("[ Hc ] Configured size: {0}, root path: {1}", new Object[]{String.valueOf(quotas.size()), PATH});
                StringBuilder message = new StringBuilder("[ Hc ] Initialize components: ");
                Ut.itJArray((JsonArray)quotas).forEach(item -> {
                    Class componentCls;
                    String path = item.getString("path", null);
                    String componentName = item.getString("component");
                    if (Ut.notNil((String)path) && !REGISTRY_CLS.containsKey(path) && Objects.nonNull(componentCls = Ut.clazz((String)componentName, null))) {
                        REGISTRY_CLS.put(path, vertx -> (Quota)Ut.instance((Class)componentCls, (Object[])new Object[]{vertx}));
                        message.append(MessageFormat.format("\n\t{0} = {1}", path, componentCls.getName()));
                    }
                });
                message.append("\n");
                LOGGER.info(message.toString(), new Object[0]);
            }
        } else {
            IS_MONITOR = false;
        }
    }
}

