/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.options;

import io.vertx.core.ClusterOptions;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.Ruler;
import io.vertx.up.exception.ZeroException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.marshal.ClusterStrada;
import io.vertx.up.uca.marshal.JTransformer;
import io.vertx.up.uca.marshal.VertxStrada;
import io.vertx.up.uca.options.NodeVisitor;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroVertx;
import io.vertx.up.util.Ut;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VertxVisitor
implements NodeVisitor {
    private static final Annal LOGGER = Annal.get(VertxVisitor.class);
    private static final String KEY = "vertx";
    private final transient Node<JsonObject> NODE = (Node)Ut.singleton(ZeroVertx.class, (Object[])new Object[0]);
    private final transient JTransformer<VertxOptions> transformer = (JTransformer)Ut.singleton(VertxStrada.class, (Object[])new Object[0]);
    private final transient JTransformer<ClusterOptions> clusterTransformer = (JTransformer)Ut.singleton(ClusterStrada.class, (Object[])new Object[0]);
    private transient ClusterOptions clusterOptions;

    public ConcurrentMap<String, VertxOptions> visit(String ... keys) throws ZeroException {
        Fn.inLenEq(this.getClass(), (int)0, (Object[])keys);
        JsonObject data = (JsonObject)this.NODE.read();
        JsonObject vertxData = data.getJsonObject(KEY);
        LOGGER.info("The raw data ( node = {0}, type = {1} ) before validation is {2}.", new Object[]{KEY, this.getClass().getSimpleName(), vertxData});
        Fn.onZero(() -> Ruler.verify((String)KEY, (JsonObject)vertxData), (Object[])new Object[]{vertxData});
        this.clusterOptions = (ClusterOptions)this.clusterTransformer.transform((Object)vertxData.getJsonObject("clustered"));
        return this.visit(vertxData.getJsonArray("instance"));
    }

    public ClusterOptions getCluster() {
        return this.clusterOptions;
    }

    private ConcurrentMap<String, VertxOptions> visit(JsonArray vertxData) throws ZeroException {
        ConcurrentHashMap<String, VertxOptions> map = new ConcurrentHashMap<String, VertxOptions>();
        boolean clustered = this.clusterOptions.isEnabled();
        Fn.etJArray((JsonArray)vertxData, JsonObject.class, (item, index) -> {
            String name = item.getString("name");
            VertxOptions options = (VertxOptions)this.transformer.transform(item);
            map.put(name, options);
        });
        return map;
    }
}

