/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.config;

import io.vertx.core.http.HttpMethod;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.zero.exception.MethodNullException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;

class MethodResolver {
    private static final Annal LOGGER = Annal.get(MethodResolver.class);
    private static final ConcurrentMap<Class<?>, HttpMethod> METHODS = new ConcurrentHashMap<Class<?>, HttpMethod>(){
        {
            this.put(GET.class, HttpMethod.GET);
            this.put(POST.class, HttpMethod.POST);
            this.put(PUT.class, HttpMethod.PUT);
            this.put(DELETE.class, HttpMethod.DELETE);
            this.put(OPTIONS.class, HttpMethod.OPTIONS);
            this.put(HEAD.class, HttpMethod.HEAD);
            this.put(PATCH.class, HttpMethod.PATCH);
        }
    };

    MethodResolver() {
    }

    public static HttpMethod resolve(Method method) {
        Fn.outUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, MethodNullException.class, (Object[])new Object[]{MethodResolver.class});
        Annotation[] annotations = method.getDeclaredAnnotations();
        HttpMethod result = null;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> key = annotation.annotationType();
            if (!METHODS.containsKey(key)) continue;
            result = (HttpMethod)METHODS.get(key);
            break;
        }
        if (null == result) {
            LOGGER.debug("Method name = {0} has not annotated with javax.ws.rs.[@GET,@POST,@PUT,@DELETE,@OPTIONS,@PATCH,@HEAD], ignored resolving.", new Object[]{method.getName()});
        }
        return result;
    }

    public static boolean isValid(Method method) {
        boolean valid;
        int modifiers = method.getModifiers();
        boolean bl = valid = Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isNative(modifiers);
        if (!valid) {
            LOGGER.debug("( Ignored ) Method name = {0} access scope is invalid, the scope must be public non-static.", new Object[]{method.getName()});
        }
        return valid;
    }
}

