/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.hunt;

import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.annotations.Codex;
import io.vertx.up.atom.Kv;
import io.vertx.up.atom.Rule;
import io.vertx.up.atom.agent.Depot;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.container.VInstance;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception.web._411ContentLengthException;
import io.vertx.up.extension.pointer.PluginExtension;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.validation.Validator;
import io.vertx.up.uca.rs.announce.Rigor;
import io.vertx.up.uca.rs.hunt.Answer;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;

class Flower {
    private static final Annal LOGGER = Annal.get(Flower.class);

    Flower() {
    }

    static <T> Future<Envelop> next(RoutingContext context, T entity) {
        Envelop envelop = Envelop.success(entity).bind(context);
        return PluginExtension.Flower.next(context, envelop);
    }

    static void replyError(RoutingContext context, WebException error, Event event) {
        Envelop envelop = Envelop.failure(error);
        Answer.reply(context, envelop, event);
    }

    static void executeRequest(RoutingContext context, Map<String, List<Rule>> rulers, Depot depot, Object[] args, Validator verifier) {
        WebException error = Flower.verifyPureArguments(verifier, depot, args);
        if (null == error) {
            error = Flower.verifyUpload(context);
        }
        if (null == error) {
            Kv<Integer, Class<?>> found = Flower.findParameter(depot.getEvent().getAction());
            if (null == found.getValue()) {
                context.next();
            } else {
                Class type = (Class)found.getValue();
                Object value = args[(Integer)found.getKey()];
                Flower.verifyCodex(context, rulers, depot, type, value);
            }
        } else {
            Flower.replyError(context, error, depot.getEvent());
        }
    }

    private static Kv<Integer, Class<?>> findParameter(Method method) {
        int index = 0;
        Kv result = Kv.create();
        for (Parameter parameter : method.getParameters()) {
            if (parameter.isAnnotationPresent(Codex.class)) {
                result.set((Object)index, parameter.getType());
                break;
            }
            ++index;
        }
        return result;
    }

    private static void verifyCodex(RoutingContext context, Map<String, List<Rule>> rulers, Depot depot, Class<?> type, Object value) {
        Rigor rigor = Rigor.get(type);
        if (null == rigor) {
            LOGGER.warn("Zero system could not find Rigor for type = {0}.", new Object[]{type});
            context.next();
        } else {
            WebException error = rigor.verify(rulers, value);
            if (null == error) {
                context.next();
            } else {
                Flower.replyError(context, error, depot.getEvent());
            }
        }
    }

    private static WebException verifyPureArguments(Validator verifier, Depot depot, Object[] args) {
        Event event = depot.getEvent();
        Object proxy = event.getProxy();
        Method method = event.getAction();
        WebException error = null;
        try {
            Object delegate;
            if (proxy instanceof VInstance) {
                VInstance vInstance = (VInstance)proxy;
                delegate = vInstance.proxy();
            } else {
                delegate = proxy;
            }
            verifier.verifyMethod(delegate, method, args);
        }
        catch (WebException ex) {
            error = ex;
        }
        return error;
    }

    private static WebException verifyUpload(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.isExpectMultipart()) {
            if (!request.headers().contains(HttpHeaders.CONTENT_LENGTH)) {
                return new _411ContentLengthException(Flower.class, 0);
            }
            return null;
        }
        return null;
    }
}

