/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.mime.parse;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Epsilon;
import io.vertx.up.eon.em.MimeFlow;
import io.vertx.up.exception.WebException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.rs.mime.Resolver;
import io.vertx.up.uca.rs.mime.Solve;
import io.vertx.up.uca.rs.mime.parse.Atomic;
import io.vertx.up.uca.rs.mime.parse.StandardAtomic;
import io.vertx.up.uca.rs.mime.parse.TypedAtomic;
import io.vertx.up.uca.rs.mime.resolver.SolveResolver;
import io.vertx.up.uca.rs.mime.resolver.UnsetResolver;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.util.Ut;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.core.MediaType;

public class MimeAtomic<T>
implements Atomic<T> {
    private static final Node<JsonObject> NODE = Node.infix((String)"resolver");
    private static final Annal LOGGER = Annal.get(MimeAtomic.class);
    private static final ConcurrentMap<String, Atomic> POOL_ATOMIC = new ConcurrentHashMap<String, Atomic>();
    private static final ConcurrentMap<String, Resolver> POOL_RESOLVER = new ConcurrentHashMap<String, Resolver>();
    private static final ConcurrentMap<String, Solve> POOL_SOLVE = new ConcurrentHashMap<String, Solve>();

    @Override
    public Epsilon<T> ingest(RoutingContext context, Epsilon<T> income) throws WebException {
        Epsilon<T> epsilon;
        if (MimeFlow.TYPED == income.getMime()) {
            Atomic atomic = (Atomic)Fn.poolThread(POOL_ATOMIC, TypedAtomic::new, (String)TypedAtomic.class.getName());
            epsilon = atomic.ingest(context, income);
        } else if (MimeFlow.STANDARD == income.getMime()) {
            Atomic atomic = (Atomic)Fn.poolThread(POOL_ATOMIC, StandardAtomic::new, (String)StandardAtomic.class.getName());
            epsilon = atomic.ingest(context, income);
        } else {
            Resolver<T> resolver = this.getResolver(context, income);
            epsilon = resolver.resolve(context, income);
        }
        return epsilon;
    }

    private Resolver<T> getResolver(RoutingContext context, Epsilon<T> income) {
        Annotation annotation = income.getAnnotation();
        Class resolverCls = (Class)Ut.invoke((Object)annotation, (String)"resolver", (Object[])new Object[0]);
        String header = context.request().getHeader("Content-Type");
        if (UnsetResolver.class == resolverCls) {
            String resolver;
            JsonObject content = (JsonObject)NODE.read();
            if (null == header) {
                resolver = content.getString("default");
                LOGGER.info("( Resolver ) Select resolver {0} as [DEFAULT] for Content-Type = null when request to {1}", new Object[]{resolver, context.request().absoluteURI()});
            } else {
                MediaType type = MediaType.valueOf((String)header);
                JsonObject resolverMap = content.getJsonObject(type.getType());
                resolver = resolverMap.getString(type.getSubtype());
                LOGGER.info("( Resolver ) Select resolver {0} for Content-Type {1} when request to {2}", new Object[]{resolver, header, context.request().absoluteURI()});
            }
            return (Resolver)Fn.poolThread(POOL_RESOLVER, () -> (Resolver)Ut.instance((String)resolver, (Object[])new Object[0]), (String)resolver);
        }
        LOGGER.info("( Resolver ) Select resolver from annotation config \"{0}\" for Content-Type {1}", new Object[]{resolverCls, header});
        if (Ut.isImplement((Class)resolverCls, Resolver.class)) {
            return (Resolver)Fn.poolThread(POOL_RESOLVER, () -> (Resolver)Ut.instance((Class)resolverCls, (Object[])new Object[0]), (String)resolverCls.getName());
        }
        Resolver resolver = (Resolver)Fn.poolThread(POOL_RESOLVER, () -> (Resolver)Ut.instance(SolveResolver.class, (Object[])new Object[0]), (String)SolveResolver.class.getName());
        Solve solve = (Solve)Fn.poolThread(POOL_SOLVE, () -> (Solve)Ut.instance((Class)resolverCls, (Object[])new Object[0]), (String)resolverCls.getName());
        Ut.contract((Object)resolver, Solve.class, (Object)solve);
        return resolver;
    }
}

