/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.router;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.up.extension.PlugRouter;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroAmbient;
import io.vertx.up.uca.rs.Axis;
import io.vertx.up.uca.rs.router.Pool;
import io.vertx.up.util.Ut;
import java.util.concurrent.atomic.AtomicInteger;

public class DynamicAxis
implements Axis<Router> {
    private static final Annal LOGGER = Annal.get(DynamicAxis.class);
    private static final AtomicInteger LOG_FLAG_START = new AtomicInteger(0);
    private static final AtomicInteger LOG_FLAG_END = new AtomicInteger(0);
    private static final transient String NAME = DynamicAxis.class.getSimpleName();
    private transient Vertx vertxRef;

    @Override
    public void mount(Router router) {
        Class clazz = ZeroAmbient.getPlugin((String)"router");
        if (0 == LOG_FLAG_START.getAndIncrement()) {
            LOGGER.info("( {0} ) The system is detecting dynamic routing component...", new Object[]{NAME});
        }
        if (null != clazz && Ut.isImplement((Class)clazz, PlugRouter.class)) {
            JsonObject routerConfig = PlugRouter.config();
            if (1 == LOG_FLAG_END.getAndIncrement()) {
                LOGGER.info("( {0} ) Zero system detect class {1} ( io.vertx.up.extension.PlugRouter ) with config {2}.", new Object[]{NAME, clazz.getName(), routerConfig.encode()});
            }
            PlugRouter plugRouter = (PlugRouter)Fn.poolThread(Pool.PLUGS, () -> (PlugRouter)Ut.instance((Class)clazz, (Object[])new Object[0]));
            plugRouter.bind(this.vertxRef);
            plugRouter.mount(router, routerConfig);
        } else if (1 == LOG_FLAG_END.getAndIncrement()) {
            LOGGER.info("( {0} ) Skip dynamic routing because clazz is null or class {1} is not assignable from \"io.vertx.up.extension.PlugRouter\".", new Object[]{NAME, Fn.getNull(null, () -> null == clazz ? null : clazz.getName(), (Object[])new Object[]{clazz})});
        }
    }

    public Axis<Router> bind(Vertx vertx) {
        this.vertxRef = vertx;
        return this;
    }
}

