/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.origin;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.di.DiGuice;
import io.vertx.up.uca.di.DiGuiceConstructor;
import io.vertx.up.uca.di.DiGuiceField;
import io.vertx.up.uca.di.DiGuiceMethod;
import io.vertx.up.uca.web.origin.Inquirer;
import io.vertx.up.util.Ut;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class GuiceInquirer
implements Inquirer<Injector> {
    private static final Annal LOGGER = Annal.get(GuiceInquirer.class);
    private static final DiGuice jsrField = (DiGuice)Ut.singleton(DiGuiceField.class, (Object[])new Object[0]);
    private static final DiGuice jsrMethod = (DiGuice)Ut.singleton(DiGuiceMethod.class, (Object[])new Object[0]);
    private static final DiGuice jsrCon = (DiGuice)Ut.singleton(DiGuiceConstructor.class, (Object[])new Object[0]);

    @Override
    public Injector scan(Set<Class<?>> clazzes) {
        LOGGER.info("[ DI ] The DI environment will be initialized! Total = `{0}`", new Object[]{String.valueOf(clazzes.size())});
        HashSet queueField = new HashSet();
        HashSet queueCon = new HashSet();
        HashSet queueMethod = new HashSet();
        ConcurrentHashMap tree = new ConcurrentHashMap();
        HashSet flat = new HashSet();
        clazzes.stream().filter(this::isValid).forEach(clazz -> {
            this.buildTree(tree, flat, (Class<?>)clazz);
            if (!clazz.isInterface()) {
                if (jsrField.success((Class<?>)clazz)) {
                    queueField.add(clazz);
                } else if (jsrMethod.success((Class<?>)clazz)) {
                    queueMethod.add(clazz);
                } else if (jsrCon.success((Class<?>)clazz)) {
                    queueCon.add(clazz);
                }
            }
        });
        LOGGER.info("[ DI ] 1st scanned, field = {0}, method = {1}, constructor = {2}", new Object[]{String.valueOf(queueField.size()), String.valueOf(queueMethod.size()), String.valueOf(queueCon.size())});
        Module[] moduleArray = new Module[3];
        moduleArray[0] = jsrField.module(tree, flat);
        moduleArray[1] = jsrCon.module(tree, flat);
        moduleArray[2] = jsrMethod.module(tree, flat);
        return Guice.createInjector((Module[])moduleArray);
    }

    private void buildTree(ConcurrentMap<Class<?>, Set<Class<?>>> tree, Set<Class<?>> flatSet, Class<?> clazz) {
        Consumer<Class> consumer = item -> {
            if (!tree.containsKey(item)) {
                tree.put((Class<?>)item, new HashSet());
            }
        };
        if (clazz.isInterface()) {
            consumer.accept(clazz);
        } else {
            Class<?>[] interfacesCls = clazz.getInterfaces();
            if (0 == interfacesCls.length) {
                flatSet.add(clazz);
            } else {
                Arrays.stream(interfacesCls).forEach(interfaceCls -> {
                    consumer.accept((Class)interfaceCls);
                    ((Set)tree.get(interfaceCls)).add(clazz);
                });
            }
        }
    }

    private boolean isValid(Class<?> clazz) {
        Class existing = Ut.clazz((String)clazz.getName(), null);
        if (Objects.isNull(existing)) {
            return false;
        }
        int modifier = clazz.getModifiers();
        if (!Modifier.isPublic(modifier)) {
            return false;
        }
        if (Modifier.isAbstract(modifier) && !clazz.isInterface()) {
            return false;
        }
        if (clazz.isAnonymousClass()) {
            return false;
        }
        return !clazz.isEnum();
    }
}

