/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.origin;

import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Job;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.eon.em.JobStatus;
import io.vertx.up.eon.em.JobType;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.web.origin.Inquirer;
import io.vertx.up.util.Ut;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class JobInquirer
implements Inquirer<Set<Mission>> {
    private static final Annal LOGGER = Annal.get(JobInquirer.class);

    @Override
    public Set<Mission> scan(Set<Class<?>> clazzes) {
        Set jobs = clazzes.stream().filter(item -> item.isAnnotationPresent(Job.class)).collect(Collectors.toSet());
        LOGGER.info("( {0} Job ) The Zero system has found {0} components of @Job.", new Object[]{jobs.size()});
        return jobs.stream().map(this::initialize).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Mission initialize(Class<?> clazz) {
        Job annotation = clazz.getAnnotation(Job.class);
        if (Objects.isNull(annotation)) {
            return null;
        }
        JobType type = (JobType)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        String name = (String)Ut.invoke((Object)annotation, (String)"name", (Object[])new Object[0]);
        name = Ut.isNil((String)name) ? clazz.getName() : name;
        Mission mission = this.config((Annotation)annotation);
        mission.setName(name);
        mission.setReadOnly(Boolean.TRUE);
        if (Objects.isNull(mission.getType())) {
            mission.setType(type);
        }
        mission.setStatus(JobStatus.STARTING);
        if (-1L == mission.getDuration()) {
            mission.setDuration(this.time((Annotation)annotation, "duration", "durationUnit"));
        }
        if (-1L == mission.getThreshold()) {
            long millSec = this.time((Annotation)annotation, "threshold", "thresholdUnit");
            mission.setThreshold(TimeUnit.MILLISECONDS.toNanos(millSec));
        }
        if (Ut.isNil((String)mission.getCode())) {
            mission.setCode("zero.vertx.jobs-" + mission.getName());
        }
        mission.connect(clazz);
        if (Objects.isNull(mission.getOn())) {
            LOGGER.warn("[ Job ] The class {0} annotated with @Job will be ignored because there is no @On method defined.", new Object[]{clazz.getName()});
            return null;
        }
        if (JobType.FIXED == type) {
            String expr = (String)Ut.invoke((Object)annotation, (String)"runAt", (Object[])new Object[0]);
            mission.setInstant(Ut.fromAt((String)expr));
        }
        return mission;
    }

    private Mission config(Annotation annotation) {
        Mission mission;
        String config = (String)Ut.invoke((Object)annotation, (String)"config", (Object[])new Object[0]);
        if (Ut.notNil((String)config)) {
            JsonObject json = Ut.ioJObject((String)this.resolve(config));
            json.remove("status");
            json.remove("name");
            json.remove("type");
            json.remove("instant");
            mission = (Mission)Ut.deserialize((JsonObject)json, Mission.class);
        } else {
            mission = new Mission();
        }
        return mission;
    }

    private long time(Annotation annotation, String field, String fieldUnit) {
        long duration = (Long)Ut.invoke((Object)annotation, (String)field, (Object[])new Object[0]);
        TimeUnit timeUnit = (TimeUnit)((Object)Ut.invoke((Object)annotation, (String)fieldUnit, (Object[])new Object[0]));
        return timeUnit.toMillis(duration);
    }

    private String resolve(String config) {
        StringBuilder file = new StringBuilder("jobs");
        if (config.startsWith("/")) {
            file.append(config);
        } else {
            file.append("/").append(config);
        }
        if (!config.endsWith(".json")) {
            file.append(".").append("json");
        }
        return file.toString().replace("//", "/");
    }
}

