/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.origin;

import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.tp.error.WallDuplicatedException;
import io.vertx.tp.error.WallKeyMissingException;
import io.vertx.tp.error.WallMethodMultiException;
import io.vertx.tp.error.WallTypeWrongException;
import io.vertx.up.annotations.Authenticate;
import io.vertx.up.annotations.Authorized;
import io.vertx.up.annotations.AuthorizedResource;
import io.vertx.up.annotations.Wall;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.eon.em.AuthWall;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.di.DiPlugin;
import io.vertx.up.uca.rs.config.EventExtractor;
import io.vertx.up.uca.web.origin.Inquirer;
import io.vertx.up.util.Ut;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class WallInquirer
implements Inquirer<Set<Aegis>> {
    private static final Annal LOGGER = Annal.get(WallInquirer.class);
    private static final DiPlugin PLUGIN = DiPlugin.create(EventExtractor.class);

    @Override
    public Set<Aegis> scan(Set<Class<?>> walls) {
        TreeSet<Aegis> wallSet = new TreeSet<Aegis>();
        Set<Class<?>> wallClass = walls.stream().filter(item -> item.isAnnotationPresent(Wall.class)).collect(Collectors.toSet());
        if (!wallClass.isEmpty()) {
            this.verifyDuplicated(wallClass);
            wallClass.stream().map(this::create).forEach(wallSet::add);
        }
        return wallSet;
    }

    private Aegis create(Class<?> clazz) {
        Aegis aegis = new Aegis();
        this.verifyProxy(clazz, aegis);
        Wall annotation = clazz.getAnnotation(Wall.class);
        String typeKey = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        this.verifyConfig(clazz, aegis, typeKey);
        aegis.setPath((String)Ut.invoke((Object)annotation, (String)"path", (Object[])new Object[0]));
        Class handlerCls = (Class)Ut.invoke((Object)annotation, (String)"handler", (Object[])new Object[0]);
        if (AuthorizationHandler.class.isAssignableFrom(handlerCls)) {
            aegis.setHandler(handlerCls);
        }
        return aegis;
    }

    private void verifyConfig(Class<?> clazz, Aegis reference, String typeKey) {
        AuthWall wall = AuthWall.from((String)typeKey);
        Fn.outUp((boolean)Objects.isNull(wall), (Annal)LOGGER, WallTypeWrongException.class, (Object[])new Object[]{this.getClass(), typeKey, clazz});
        reference.setType(wall);
        ConcurrentMap configMap = AegisItem.configMap();
        if (AuthWall.EXTENSION == wall) {
            reference.setDefined(Boolean.TRUE.booleanValue());
            configMap.forEach((arg_0, arg_1) -> ((Aegis)reference).addItem(arg_0, arg_1));
        } else {
            reference.setDefined(Boolean.FALSE.booleanValue());
            AegisItem found = configMap.getOrDefault(wall.key(), null);
            Fn.outUp((boolean)Objects.isNull(found), (Annal)LOGGER, WallKeyMissingException.class, (Object[])new Object[]{this.getClass(), wall.key(), clazz});
            reference.setItem(found);
        }
    }

    private void verifyProxy(Class<?> clazz, Aegis reference) {
        Method[] methods = clazz.getDeclaredMethods();
        Fn.outUp((boolean)this.verifyMethod(methods, Authenticate.class), (Annal)LOGGER, WallMethodMultiException.class, (Object[])new Object[]{this.getClass(), Authenticate.class.getSimpleName(), clazz.getName()});
        Fn.outUp((boolean)this.verifyMethod(methods, Authorized.class), (Annal)LOGGER, WallMethodMultiException.class, (Object[])new Object[]{this.getClass(), Authorized.class.getSimpleName(), clazz.getName()});
        Fn.outUp((boolean)this.verifyMethod(methods, AuthorizedResource.class), (Annal)LOGGER, WallMethodMultiException.class, (Object[])new Object[]{this.getClass(), AuthorizedResource.class.getSimpleName(), clazz.getName()});
        reference.setProxy(PLUGIN.createComponent(clazz));
        Arrays.stream(methods).forEach(method -> {
            if (Objects.nonNull(method)) {
                if (method.isAnnotationPresent(Authenticate.class)) {
                    reference.getAuthorizer().setAuthenticate(method);
                }
                if (method.isAnnotationPresent(Authorized.class)) {
                    reference.getAuthorizer().setAuthorization(method);
                }
                if (method.isAnnotationPresent(AuthorizedResource.class)) {
                    reference.getAuthorizer().setResource(method);
                }
            }
        });
    }

    private boolean verifyMethod(Method[] methods, Class<? extends Annotation> clazz) {
        long found = Arrays.stream(methods).filter(method -> method.isAnnotationPresent(clazz)).count();
        return 1L < found;
    }

    private void verifyDuplicated(Set<Class<?>> wallClses) {
        HashSet dupSet = new HashSet();
        wallClses.forEach(item -> {
            Wall annotation = item.getAnnotation(Wall.class);
            Integer order = (Integer)Ut.invoke((Object)annotation, (String)"order", (Object[])new Object[0]);
            String path = (String)Ut.invoke((Object)annotation, (String)"path", (Object[])new Object[0]);
            String wallKey = Ut.encryptSHA256((String)(order + path));
            dupSet.add(wallKey);
        });
        Fn.outUp((dupSet.size() != wallClses.size() ? 1 : 0) != 0, (Annal)LOGGER, WallDuplicatedException.class, (Object[])new Object[]{this.getClass(), wallClses.stream().map(Class::getName).collect(Collectors.toSet())});
    }
}

