/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.parallel;

import io.vertx.up.fn.Actuator;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.web.parallel.ThreadAtom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class ThreadQueue {
    private static final Annal LOGGER = Annal.get(ThreadQueue.class);
    private final CountDownLatch counter;
    private final List<Thread> threads = new ArrayList<Thread>();

    public ThreadQueue(int size) {
        this.counter = new CountDownLatch(size);
    }

    public void add(Actuator runnable, String name) {
        ThreadAtom thread = new ThreadAtom(this.counter, runnable);
        thread.setName(name);
        this.threads.add(thread);
    }

    public void startSync() {
        this.startAsync();
        try {
            this.counter.await();
        }
        catch (InterruptedException ex) {
            LOGGER.jvm((Throwable)ex);
        }
    }

    private void startAsync() {
        for (Thread thread : this.threads) {
            thread.start();
        }
    }
}

