/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.eventbus.EnvelopCodec;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.up.commune.Envelop;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class Atomic {
    private static final Vertx VERTX;

    Atomic() {
    }

    static Vertx nativeVertx() {
        return VERTX;
    }

    static WorkerExecutor nativeWorker(String name, Integer minutes) {
        return VERTX.createSharedWorkerExecutor(name, 2, (long)minutes.intValue(), TimeUnit.MINUTES);
    }

    static Future<Boolean> nativeInit(JsonArray components, Vertx vertx) {
        ArrayList async = new ArrayList();
        ArrayList sync = new ArrayList();
        Ut.itJArray((JsonArray)components).forEach(json -> {
            String className = json.getString("component");
            Class clazz = Ut.clazz((String)className, null);
            if (Objects.nonNull(clazz)) {
                boolean isAsync = json.getBoolean("async", Boolean.FALSE);
                if (isAsync) {
                    Future ret = (Future)Atomic.invoke(clazz, vertx);
                    if (Objects.nonNull(ret)) {
                        async.add(ret);
                    }
                } else {
                    sync.add(clazz);
                }
            }
        });
        return Ux.thenCombineT(async).compose(ret -> {
            ArrayList futures = new ArrayList();
            sync.stream().map(each -> Atomic.invokeSync(each, vertx)).forEach(futures::add);
            return Ux.thenCombineT(futures);
        }).compose(nil -> Future.succeededFuture((Object)Boolean.TRUE));
    }

    private static Future<Boolean> invokeSync(Class<?> clazz, Vertx vertx) {
        Atomic.invoke(clazz, vertx);
        return Future.succeededFuture((Object)Boolean.TRUE);
    }

    private static Object invoke(Class<?> clazz, Vertx vertx) {
        return Fn.getJvm(() -> {
            Method initMethod = Arrays.asList(clazz.getDeclaredMethods()).stream().filter(method -> "init".equals(method.getName())).findFirst().orElse(null);
            if (Objects.isNull(initMethod)) {
                return null;
            }
            int counter = initMethod.getParameterTypes().length;
            if (0 == counter) {
                return initMethod.invoke(null, new Object[0]);
            }
            if (Objects.isNull(vertx)) {
                return null;
            }
            return initMethod.invoke(null, vertx);
        }, (Object[])new Object[0]);
    }

    static {
        VertxOptions options = new VertxOptions();
        options.setMaxEventLoopExecuteTime(3000000000000L);
        options.setMaxWorkerExecuteTime(3000000000000L);
        options.setBlockedThreadCheckInterval(10000L);
        VERTX = Vertx.vertx((VertxOptions)options);
        VERTX.eventBus().registerDefaultCodec(Envelop.class, (MessageCodec)Ut.singleton(EnvelopCodec.class, (Object[])new Object[0]));
    }
}

