/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.Record;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.unity.From;
import io.vertx.up.unity.To;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;

class Compare {
    Compare() {
    }

    static <T> ConcurrentMap<ChangeFlag, List<T>> compare(List<T> original, List<T> current, Set<String> uniqueSet, String pojoFile) {
        return Compare.compare(original, current, (T entity) -> {
            JsonObject uniqueValue = new JsonObject();
            uniqueSet.forEach(field -> {
                Object fieldValue = Ut.field((Object)entity, (String)field);
                uniqueValue.put(field, fieldValue);
            });
            return uniqueValue;
        }, pojoFile);
    }

    static <T, R> ConcurrentMap<ChangeFlag, List<T>> compare(List<T> original, List<T> current, Function<T, R> fnValue, String pojoFile) {
        ConcurrentHashMap comparedMap = new ConcurrentHashMap<ChangeFlag, List<T>>(){
            {
                this.put(ChangeFlag.DELETE, new ArrayList());
                this.put(ChangeFlag.UPDATE, new ArrayList());
                this.put(ChangeFlag.ADD, new ArrayList());
            }
        };
        if (Objects.isNull(original) || original.isEmpty()) {
            if (Objects.nonNull(current)) {
                ((List)comparedMap.get(ChangeFlag.ADD)).addAll(current);
            }
        } else {
            original.forEach(originalItem -> {
                Object latestItem = Compare.find(current, originalItem, fnValue);
                if (Objects.isNull(latestItem)) {
                    ((List)comparedMap.get(ChangeFlag.DELETE)).add(originalItem);
                }
            });
            current.forEach(latestItem -> {
                Object previous = Compare.find(original, latestItem, fnValue);
                if (Objects.isNull(previous)) {
                    ((List)comparedMap.get(ChangeFlag.ADD)).add(latestItem);
                } else {
                    Object updated = Compare.combine(previous, latestItem, pojoFile);
                    ((List)comparedMap.get(ChangeFlag.UPDATE)).add(updated);
                }
            });
        }
        return comparedMap;
    }

    private static <T> T combine(T old, T latest, String pojo) {
        if (Objects.isNull(old) && Objects.isNull(latest)) {
            return null;
        }
        if (Objects.isNull(old)) {
            return latest;
        }
        if (Objects.isNull(latest)) {
            return old;
        }
        JsonObject combineJson = Ut.valueJObject((JsonObject)To.toJObject(old, pojo));
        JsonObject latestJson = Ut.valueJObject((JsonObject)To.toJObject(latest, pojo));
        if (latestJson.containsKey("key")) {
            latestJson.remove("key");
        }
        combineJson.mergeIn(latestJson, true);
        Class<?> clazz = latest.getClass();
        return (T)From.fromJson(combineJson, clazz, pojo);
    }

    private static <T, R> T find(List<T> list, T current, Function<T, R> fnValue) {
        if (Objects.isNull(list) || list.isEmpty() || Objects.isNull(current)) {
            return null;
        }
        Object comparedValue = fnValue.apply(current);
        if (Objects.isNull(comparedValue)) {
            return null;
        }
        return list.stream().filter(Objects::nonNull).filter(each -> comparedValue.equals(fnValue.apply(each))).findAny().orElse(null);
    }

    static <T> T updateT(T query, JsonObject params) {
        Objects.requireNonNull(query);
        Class<?> entityCls = query.getClass();
        JsonObject original = Ux.toJson(query);
        original.mergeIn(params, true);
        return (T)From.fromJson(original, entityCls, "");
    }

    static <ID> Record updateR(Record record, JsonObject data, Supplier<ID> supplier) {
        Objects.requireNonNull(record);
        record.set(data);
        Object key = record.key();
        if (Objects.isNull(key)) {
            record.key(supplier.get());
        }
        return record;
    }

    static List<Record> updateR(List<Record> recordList, JsonArray array, String field) {
        ConcurrentMap dataMap = Ut.elementMap((JsonArray)array, (String)field);
        recordList.forEach(record -> {
            JsonObject dataJ;
            String key = (String)record.key();
            if (Objects.nonNull(key) && Ut.notNil((JsonObject)(dataJ = dataMap.getOrDefault(key, new JsonObject())))) {
                dataJ.remove(field);
                record.set(dataJ);
            }
        });
        return recordList;
    }

    static <T> List<T> updateT(List<T> query, JsonArray params, String field) {
        Objects.requireNonNull(query);
        if (query.isEmpty()) {
            return new ArrayList();
        }
        ConcurrentMap dataMap = Ut.elementMap((JsonArray)params, (String)field);
        ArrayList result = new ArrayList();
        query.forEach(item -> {
            Object key = Ut.field((Object)item, (String)field);
            if (Objects.nonNull(key)) {
                JsonObject merge = (JsonObject)dataMap.get(key.toString());
                Object entity = Compare.updateT(item, merge);
                result.add(entity);
            }
        });
        return result;
    }

    static <T> Future<JsonArray> run(ConcurrentMap<ChangeFlag, List<T>> compared, Function<List<T>, Future<List<T>>> insertAsyncFn, Function<List<T>, Future<List<T>>> updateAsyncFn) {
        List qUpdate;
        ArrayList<Future<JsonArray>> futures = new ArrayList<Future<JsonArray>>();
        List qAdd = compared.getOrDefault(ChangeFlag.ADD, new ArrayList());
        if (!qAdd.isEmpty()) {
            futures.add(insertAsyncFn.apply(qAdd).compose(Ux::futureA));
        }
        if (!(qUpdate = (List)compared.getOrDefault(ChangeFlag.UPDATE, new ArrayList())).isEmpty()) {
            futures.add((Future<JsonArray>)updateAsyncFn.apply(qUpdate).compose(Ux::futureA));
        }
        return Ux.thenCombineArray(futures);
    }
}

