/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.Future;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

class Debug {
    Debug() {
    }

    static void monitor(Object ... objects) {
        for (Object reference : objects) {
            Debug.monitor(reference);
        }
    }

    private static void monitor(Object object) {
        StringBuilder builder = new StringBuilder();
        builder.append("\t\t[ ZERO Debug ] ---> Start \n");
        builder.append("\t\t[ ZERO Debug ] object = ").append(object).append("\n");
        if (null != object) {
            builder.append("\t\t[ ZERO Debug ] type = ").append(object.getClass()).append("\n");
            builder.append("\t\t[ ZERO Debug ] json = ").append(Ut.serialize((Object)object)).append("\n");
            builder.append("\t\t[ ZERO Debug ] toString = ").append(object.toString()).append("\n");
            builder.append("\t\t[ ZERO Debug ] hashCode = ").append(object.hashCode()).append("\n");
        }
        builder.append("\t\t[ ZERO Debug ] <--- End \n");
        System.err.println(builder.toString());
    }

    static <T> Future<T> debug(T item) {
        Fn.safeNull(() -> Debug.monitor(item), (Object[])new Object[]{item});
        return Future.succeededFuture(item);
    }

    static <T> T debug(Throwable error, Supplier<T> supplier) {
        if (Objects.nonNull(error)) {
            error.printStackTrace();
        }
        return supplier.get();
    }

    static Function<Throwable, Envelop> otherwise() {
        return error -> {
            if (Objects.nonNull(error)) {
                error.printStackTrace();
                if (error instanceof WebException) {
                    return Envelop.failure((WebException)error);
                }
                return Envelop.failure(error);
            }
            return Envelop.ok();
        };
    }

    static <T> Function<Throwable, T> otherwise(Supplier<T> supplier) {
        return error -> {
            if (Objects.nonNull(error)) {
                error.printStackTrace();
            }
            return supplier.get();
        };
    }
}

