/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.Envelop;
import io.vertx.up.unity.Combine;
import io.vertx.up.unity.To;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

class Web {
    Web() {
    }

    static <T> Handler<AsyncResult<T>> toHandler(Message<Envelop> message) {
        return handler -> {
            if (handler.succeeded()) {
                message.reply((Object)To.toEnvelop(handler.result()));
            } else {
                if (null != handler.cause()) {
                    handler.cause().printStackTrace();
                }
                message.reply((Object)Envelop.failure(To.toError(Web.class, handler.cause())));
            }
        };
    }

    static <T> Future<T> toFuture(Consumer<Handler<AsyncResult<T>>> handler) {
        Promise promise = Promise.promise();
        handler.accept(result -> {
            if (result.succeeded()) {
                promise.complete(result.result());
            } else {
                promise.fail(result.cause());
            }
        });
        return promise.future();
    }

    static <T> Future<JsonObject> toAttach(JsonObject input, Function<T, Future<JsonObject>> function) {
        ConcurrentHashMap<String, String> indexMap = new ConcurrentHashMap<String, String>();
        ArrayList<Future<JsonObject>> futures = new ArrayList<Future<JsonObject>>();
        Iterator it = input.fieldNames().iterator();
        int index = 0;
        while (it.hasNext()) {
            String field = (String)it.next();
            Object value = input.getValue(field);
            if (!Objects.nonNull(value)) continue;
            indexMap.put(field, String.valueOf(index));
            futures.add(function.apply(value));
            ++index;
        }
        return Combine.thenCombine(futures.toArray(new Future[0])).compose(response -> {
            JsonObject finalJson = new JsonObject();
            JsonObject reference = (JsonObject)response;
            indexMap.forEach((field, indexKey) -> {
                JsonObject data = reference.getJsonObject(indexKey);
                if (Ut.notNil((JsonObject)data)) {
                    finalJson.put(field, (Object)data.copy());
                }
            });
            return To.future(finalJson);
        });
    }

    static <T> Function<JsonObject, Future<JsonObject>> toAttachJ(String field, Function<T, Future<JsonObject>> function) {
        return json -> {
            if (Ut.isNil((JsonObject)json) || !json.containsKey(field)) {
                return To.future(json);
            }
            JsonObject combine = json.getJsonObject(field);
            if (Ut.isNil((JsonObject)combine)) {
                return To.future(json);
            }
            return Web.toAttach(combine, function).compose(response -> {
                if (Ut.notNil((JsonObject)response)) {
                    json.put(field, response);
                }
                return To.future(json);
            });
        };
    }

    static <T> Function<T, Future<JsonObject>> toAttachJ(String field, JsonObject data) {
        return json -> {
            if (Objects.nonNull(json)) {
                data.put(field, json);
            }
            return To.future(data);
        };
    }

    static <T> Function<JsonObject, Future<JsonObject>> toAttach(String field, Function<T, Future<JsonObject>> function) {
        return json -> {
            if (Ut.isNil((JsonObject)json) || !json.containsKey(field)) {
                return To.future(json);
            }
            Object value = json.getValue(field);
            if (Objects.isNull(value)) {
                return To.future(json);
            }
            return ((Future)function.apply(value)).compose(data -> {
                if (Ut.notNil((JsonObject)data)) {
                    json.put(field, data);
                }
                return To.future(json);
            });
        };
    }

    static JsonObject pageData(JsonArray data, Long count) {
        if (Ut.isNil((JsonArray)data)) {
            data = new JsonArray();
        }
        if (Objects.isNull(count) || 0L > count) {
            count = 0L;
        }
        return new JsonObject().put("list", (Object)data).put("count", (Object)count);
    }

    static JsonObject pageData(JsonObject pageData, Function<JsonArray, JsonArray> function) {
        JsonArray data = Ut.valueJArray((JsonArray)pageData.getJsonArray("list"));
        JsonArray updated = Objects.nonNull(function) ? function.apply(data) : data;
        return pageData.put("list", (Object)updated);
    }
}

